% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icr.R
\name{compute_icr}
\alias{compute_icr}
\title{Compute intercoder reliability estimates for one test variable}
\usage{
compute_icr(test_var, data, unit_var, coder_var, levels = c(),
  na.omit = FALSE, agreement = TRUE, holsti = TRUE,
  kripp_alpha = TRUE, cohens_kappa = FALSE, fleiss_kappa = FALSE,
  brennan_prediger = FALSE)
}
\arguments{
\item{test_var}{Variable to compute estimates for}

\item{data}{a \link[tibble:tibble-package]{tibble}}

\item{unit_var}{Variable with unit identifiers}

\item{coder_var}{Variable with coder identifiers}

\item{levels}{Optional named vector with levels of test variables}

\item{na.omit}{Logical indicating whether \code{NA} values should be stripped
before computation. Defaults to \code{FALSE}.}

\item{agreement}{Logical indicating whether simple percent agreement should
be computed. Defaults to \code{TRUE}.}

\item{holsti}{Logical indicating whether Holsti's reliability estimate
(mean pairwise agreement) should be computed. Defaults to \code{TRUE}.}

\item{kripp_alpha}{Logical indicating whether Krippendorff's Alpha should
be computed. Defaults to \code{TRUE}.}

\item{cohens_kappa}{Logical indicating whether Cohen's Kappa should
be computed. Defaults to \code{FALSE}.}

\item{fleiss_kappa}{Logical indicating whether Fleiss' Kappa should
be computed. Defaults to \code{FALSE}.}

\item{brennan_prediger}{Logical indicating whether Brennan & Prediger's Kappa
should be computed. Defaults to \code{FALSE}.}
}
\description{
Computes intercoder reliability estimates for one test variable
}
\seealso{
Other intercoder reliability: \code{\link{icr_agreement}},
  \code{\link{icr_brennan_prediger}},
  \code{\link{icr_cohens_kappa}},
  \code{\link{icr_fleiss_kappa}},
  \code{\link{icr_holstis_CR}},
  \code{\link{icr_kripp_alpha}}, \code{\link{test_icr}},
  \code{\link{unit_coder_matrix}}
}
\concept{intercoder reliability}
