% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.cluster_fit}
\alias{augment.cluster_fit}
\title{Augment data with predictions}
\usage{
\method{augment}{cluster_fit}(x, new_data, ...)
}
\arguments{
\item{x}{A \code{cluster_fit} object produced by \code{\link[=fit.cluster_spec]{fit.cluster_spec()}} or
\code{\link[=fit_xy.cluster_spec]{fit_xy.cluster_spec()}} .}

\item{new_data}{A data frame or matrix.}

\item{...}{Not currently used.}
}
\value{
A \code{tibble::tibble()} with containing \code{new_data} with columns added
depending on the mode of the model.
}
\description{
\code{augment()} will add column(s) for predictions to the given data.
}
\details{
For partition models, a \code{.pred_cluster} column is added.
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

kmeans_fit \%>\%
  augment(new_data = mtcars)
}
