% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CET}
\alias{CET}
\title{Hadley Centre Central England Temperature}
\format{
An object of class \code{xts} (inherits from \code{zoo}) with 362 rows and 1 columns.
}
\source{
\url{https://www.metoffice.gov.uk/hadobs/hadcet/}
}
\usage{
CET
}
\description{
Mean annual temperatures in Central England
}
\details{
The CET time series is perhaps the longest instrumental record of
surface temperatures in the world, commencing in 1659 and
spanning 362 years through 2020. The CET series is a benchmark
for European climate studies, as it is sensitive to atmospheric variability
in the North Atlantic (Parker et al. 1992). This record has been previously
analyzed for long-term changes (Plaut et al. 1995;
Harvey and Mills 2003; Hillebrand and Proietti 2017); however, to our
knowledge, no detailed changepoint analysis of it has been previously
conducted. The length of the CET record affords us the opportunity to
explore a variety of temperature features.
}
\references{
\itemize{
\item Shi, et al. (2022, \doi{10.1175/JCLI-D-21-0489.1}),
\item Parker, et al. (1992, \doi{10.1002/joc.3370120402})
}
}
\keyword{datasets}
