% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variables.R
\name{get_variables}
\alias{get_variables}
\alias{get_variables.default}
\alias{get_variables.mcmc}
\alias{get_variables.mcmc.list}
\title{Get the names of the variables in a fitted Bayesian model}
\usage{
get_variables(model)

\method{get_variables}{default}(model)

\method{get_variables}{mcmc}(model)

\method{get_variables}{mcmc.list}(model)
}
\arguments{
\item{model}{A supported Bayesian model fit. Tidybayes supports a variety of model objects;
for a full list of supported models, see \link{tidybayes-models}.}
}
\value{
A character vector of variable names in the fitted model.
}
\description{
Get a character vector of the names of the variables in a variety of fitted
Bayesian model types. All models supported by \code{\link[=tidy_draws]{tidy_draws()}} are
supported.
}
\details{
This function is often useful for inspecting a model interactively in order
to construct calls to \code{\link[=spread_draws]{spread_draws()}} or \code{\link[=gather_draws]{gather_draws()}}
in order to extract draws from models in a tidy format.
}
\examples{

data(line, package = "coda")
get_variables(line)

data(RankCorr, package = "tidybayes")
get_variables(RankCorr)

}
\seealso{
\code{\link[=spread_draws]{spread_draws()}}, \code{\link[=gather_draws]{gather_draws()}}.
}
\author{
Matthew Kay
}
\keyword{manip}
