% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_contingency_tab.R
\name{bf_contingency_tab}
\alias{bf_contingency_tab}
\title{Bayes Factor for contingency table analysis}
\usage{
bf_contingency_tab(
  data,
  x,
  y = NULL,
  counts = NULL,
  ratio = NULL,
  sampling.plan = "indepMulti",
  fixed.margin = "rows",
  prior.concentration = 1,
  top.text = NULL,
  output = "dataframe",
  k = 2L,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The variable to use as the \strong{rows} in the contingency table.}

\item{y}{The variable to use as the \strong{columns} in the contingency
table. Default is \code{NULL}. If \code{NULL}, one-sample proportion test (a goodness
of fit test) will be run for the \code{main} variable. Otherwise an appropriate
association test will be run.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation.}

\item{ratio}{A vector of proportions: the expected proportions for the
proportion test (should sum to 1). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
This means if there are two levels this will be \code{ratio = c(0.5,0.5)} or if
there are four levels this will be \code{ratio = c(0.25,0.25,0.25,0.25)}, etc.}

\item{sampling.plan}{Character describing the sampling plan. Possible options
are \code{"indepMulti"} (independent multinomial; default), \code{"poisson"},
\code{"jointMulti"} (joint multinomial), \code{"hypergeom"} (hypergeometric). For
more, see \code{?BayesFactor::contingencyTableBF()}.}

\item{fixed.margin}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}

\item{prior.concentration}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}

\item{top.text}{Text to display as top.text (will be displayed on top of the
Bayes Factor top.text/message).}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{...}{
  Arguments passed on to \code{\link[=bf_extractor]{bf_extractor}}
  \describe{
    \item{\code{conf.level}}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}
    \item{\code{centrality}}{The point-estimates (centrality indices) to compute.
Character (vector) or list with one or more of these options: \code{"median"},
\code{"mean"}, \code{"MAP"} or \code{"all"}.}
    \item{\code{conf.method}}{The type of index used for Credible Interval. Can be
\code{"hdi"} (default, see \code{\link[bayestestR:hdi]{bayestestR::hdi()}}), \code{"eti"} (see
\code{\link[bayestestR:eti]{bayestestR::eti()}}) or \code{"si"} (see \code{\link[bayestestR:si]{bayestestR::si()}}).}
  }}
}
\description{
Bayes Factor for contingency table analysis
}
\examples{
# for reproducibility
set.seed(123)
library(tidyBF)

# ------------------ association tests --------------------------------

# to get dataframe
bf_contingency_tab(
  data = mtcars,
  x = am,
  y = cyl,
  output = "dataframe"
)

# ------------------ goodness of fit tests --------------------------------

# to get expression
bf_contingency_tab(
  data = mtcars,
  x = am,
  prior.concentration = 10,
  output = "expression"
)
}
\seealso{
\code{\link{bf_corr_test}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_ttest}}
}
