% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-regression-residuals.R
\name{plot_regression_residuals}
\alias{plot_regression_residuals}
\title{Create ggplot2 plot of regression residuals}
\usage{
plot_regression_residuals(.data)
}
\arguments{
\item{.data}{The data from the output of the \code{extract_regression_residuals()}
function.}
}
\value{
A list of ggplot2 plots or a faceted plot.
}
\description{
Create a ggplot2 plot of regression residuals.
}
\details{
Create a ggplot2 plot of regression residuals. The output of this
function can either be a list of plots or a single faceted plot. This function
takes the output of the \code{extract_regression_residuals()} function.
}
\examples{
library(recipes)

rec_obj <- recipe(mpg ~ ., data = mtcars)
frt_tbl <- fast_regression(
  mtcars,
  rec_obj,
  .parsnip_eng = c("lm","glm"),
  .parsnip_fns = "linear_reg"
  )

extract_regression_residuals(frt_tbl, FALSE)[1] |> plot_regression_residuals()
extract_regression_residuals(frt_tbl, TRUE)[1] |> plot_regression_residuals()

}
\seealso{
Other Plotting: 
\code{\link{plot_regression_predictions}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plotting}
