% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-mod-spec.R
\name{extract_model_spec}
\alias{extract_model_spec}
\title{Extract A Model Specification}
\usage{
extract_model_spec(.data, .model_id = NULL)
}
\arguments{
\item{.data}{The model table that must have the class \code{tidyaml_mod_spec_tbl}.}

\item{.model_id}{The model number that you want to select, Must be an integer
or sequence of integers, ie. \code{1} or \code{c(1,3,5)} or \code{1:2}}
}
\value{
A tibble with the chosen model specification(s).
}
\description{
Extract a model specification from a tidyAML model tibble.
}
\details{
This function allows you to get a model specification or more from
a tibble with a class of "tidyaml_mod_spec_tbl". It allows you to select the
model by the \code{.model_id} column. You can call the model id's by an integer
or a sequence of integers.
}
\examples{
spec_tbl <- fast_regression_parsnip_spec_tbl(
  .parsnip_fns = "linear_reg",
  .parsnip_eng = c("lm","glm")
)

extract_model_spec(spec_tbl, 1)
extract_model_spec(spec_tbl, 1:2)

}
\seealso{
Other Extractor: 
\code{\link{extract_regression_residuals}()},
\code{\link{extract_wflw}()},
\code{\link{extract_wflw_fit}()},
\code{\link{extract_wflw_pred}()},
\code{\link{get_model}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Extractor}
