% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-create-splits.R
\name{create_splits}
\alias{create_splits}
\title{Utility Create Splits Object}
\usage{
create_splits(.data, .split_type = "initial_split", .split_args = NULL)
}
\arguments{
\item{.data}{The data being passed to make a split on}

\item{.split_type}{The default is "initial_split", you can pass any other split
type from the \code{rsample} library.}

\item{.split_args}{The default is NULL in order to use the default split arguments.
If you want to pass other arguments then must pass a list with the parameter name
and the argument.}
}
\value{
A list object
}
\description{
Create a splits object.
}
\details{
Create a splits object that returns a list object of both the
splits object itself and the splits type. This function supports all splits
types from the \code{rsample} package.
}
\examples{
create_splits(mtcars, .split_type = "vfold_cv")

}
\seealso{
Other Utility: 
\code{\link{core_packages}()},
\code{\link{create_workflow_set}()},
\code{\link{fast_classification_parsnip_spec_tbl}()},
\code{\link{fast_regression_parsnip_spec_tbl}()},
\code{\link{install_deps}()},
\code{\link{load_deps}()},
\code{\link{match_args}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
