% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round-index.R
\name{floor_index}
\alias{floor_index}
\title{A simple wrapper of \code{\link[lubridate:floor_date]{lubridate::floor_date()}}}
\usage{
floor_index(x, unit = "seconds")
}
\arguments{
\item{x}{a vector of date-time objects}

\item{unit}{a character string specifying a time unit or a multiple of a unit
to be rounded to. Valid base units are \code{second}, \code{minute}, \code{hour}, \code{day},
\code{week}, \code{month}, \code{bimonth}, \code{quarter}, \code{season}, \code{halfyear} and
\code{year}. Arbitrary unique English abbreviations as in the \code{\link[lubridate:period]{period()}}
constructor are allowed. Rounding to multiples of units (except weeks) is
supported.}
}
\description{
This is a thin wrapper around a \code{\link[lubridate:floor_date]{lubridate::floor_date()}} that works
for \code{hms}, \code{yearmon}, and \code{yearqtr} classes as well.
}
\examples{

data(FB)
dplyr::mutate(FB, date2 = floor_index(date, "year"))

time_test <- create_series('00:00:00'~'12:00:00',
                           '1 minute', class = "hms")

dplyr::mutate(time_test, date2 = floor_index(date, "hour"))

}
\seealso{
\code{\link[lubridate:floor_date]{lubridate::floor_date()}}
}
