% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_scatter.R
\name{three_scatter}
\alias{three_scatter}
\title{3D Scatter Plot}
\usage{
three_scatter(x, y, z, size = 1, col = 1, label = NULL, group = 1,
  timestamp = NULL, pal = NULL, scale = 1, axis = TRUE,
  control_panel = TRUE, control_presets = NULL, camera_pos, ...)
}
\arguments{
\item{x, y, z}{numeric vectors with the same length \code{n}.}

\item{size}{size for each point.}

\item{col}{color vector/matrix, can be either numeric or factor.
Its length (vector) or nrow (matrix) must be either \code{n} or 1.}

\item{label}{text label of each observation.}

\item{group}{categorical group names of each points.}

\item{timestamp}{numeric vector, length of 0 or \code{ncol(col)}.}

\item{pal}{color palette, vector of colors, can be integers.}

\item{scale}{'auto', \code{NULL}, or numeric, rescale the final coordinates.
Default 1, no re-scale.}

\item{axis}{logical, draw axis.}

\item{control_panel}{logical, show sidebar (control panel).}

\item{control_presets}{if control_panel is true, which widgets to show.}

\item{camera_pos}{initial camera position, auto assign if missing.}

\item{...}{other arguments passing to \code{threejs_brain}.}
}
\description{
3D Scatter Plot
}
\examples{

#' Continuous color example:

data("iris")
three_scatter(x = iris$Sepal.Length, y = iris$Sepal.Width,
              z = iris$Petal.Length, size = 0.1,
              col = iris$Petal.Width, group = iris$Species,
              pal = c('orange', 'blue3', 'darkgreen'),
              start_zoom = 12, axis = FALSE)


# Discrete example:

x = rnorm(26, c(10, 10, -20))
y = rnorm(26, c(10, -10, 10))
z = rnorm(26, c(10, 40, -10))
three_scatter(x, y, z, size = 1, col = sample(letters[1:3], 20, TRUE),
              pal = c('orange', 'blue3', 'darkgreen'))

}
\author{
Zhengjia Wang
}
