% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_arg.R
\name{add_arg_if}
\alias{add_arg_if}
\title{Add defaults to argument list}
\usage{
add_arg_if(args, ..., override = FALSE)
}
\arguments{
\item{args}{Argument list}

\item{...}{Other named arguments are added (depending on override) and
returned with args}

\item{override}{Logical indicating whether to override existing values in
args with the values provided as a named argument here.}
}
\value{
Argument list with updated values.
}
\description{
Adds parameters to argument list if list does not already include those
parameters
}
\examples{
## arg list
args <- list(x = 5, y = TRUE, z = FALSE)

## add arg defaults
add_arg_if(args, w = TRUE, z = TRUE)

## add arg defaults, overriding any previous values
add_arg_if(args, x = 10, z = TRUE, override = TRUE)

}
