% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/training_run.R
\name{training_run}
\alias{training_run}
\title{Run a training script}
\usage{
training_run(file = "train.R", type = "local",
  config = Sys.getenv("R_CONFIG_ACTIVE", unset = "default"), flags = NULL,
  properties = NULL, run_dir = NULL, echo = FALSE,
  envir = parent.frame(), encoding = getOption("encoding"))
}
\arguments{
\item{file}{Path to training script (defaults to "train.R")}

\item{type}{Run type (defaults to "local")}

\item{config}{The configuration to use. Defaults to the active configuration
for the current environment (as specified by the \code{R_CONFIG_ACTIVE}
environment variable), or \code{default} when unset.}

\item{flags}{Named character vector with flag values (see \code{\link[=flags]{flags()}}) or path
to YAML file containing flag values.}

\item{properties}{Named character vector with run properties. Properties are
additional metadata about the run which will be subsequently available via
\code{\link[=ls_runs]{ls_runs()}}.}

\item{run_dir}{Directory to store run data within}

\item{echo}{Print expressions within training script}

\item{envir}{The environment in which the script should be evaluated}

\item{encoding}{The encoding of the training script; see \code{\link[=file]{file()}}.}
}
\value{
Single row data frame with run flags, metrics, etc.
}
\description{
Run a training script
}
