% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijectors.R
\name{tfb_affine}
\alias{tfb_affine}
\title{Affine bijector}
\usage{
tfb_affine(
  shift = NULL,
  scale_identity_multiplier = NULL,
  scale_diag = NULL,
  scale_tril = NULL,
  scale_perturb_factor = NULL,
  scale_perturb_diag = NULL,
  adjoint = FALSE,
  validate_args = FALSE,
  name = "affine",
  dtype = NULL
)
}
\arguments{
\item{shift}{Floating-point Tensor. If this is set to NULL, no shift is applied.}

\item{scale_identity_multiplier}{floating point rank 0 Tensor representing a scaling done
to the identity matrix. When \code{scale_identity_multiplier = scale_diag = scale_tril = NULL} then
\verb{scale += IdentityMatrix}. Otherwise no scaled-identity-matrix is added to \code{scale}.}

\item{scale_diag}{Floating-point Tensor representing the diagonal matrix.
\code{scale_diag} has shape \verb{[N1, N2, ...  k]}, which represents a k x k diagonal matrix.
When NULL no diagonal term is added to \code{scale}.}

\item{scale_tril}{Floating-point Tensor representing the lower triangular matrix.
\code{scale_tril} has shape \verb{[N1, N2, ...  k, k]}, which represents a k x k lower triangular matrix.
When NULL no \code{scale_tril} term is added to \code{scale}. The upper triangular elements above the diagonal are ignored.}

\item{scale_perturb_factor}{Floating-point Tensor representing factor matrix with last
two dimensions of shape \verb{(k, r)} When NULL, no rank-r update is added to scale.}

\item{scale_perturb_diag}{Floating-point Tensor representing the diagonal matrix.
\code{scale_perturb_diag} has shape \verb{[N1, N2, ...  r]}, which represents an r x r diagonal matrix.
When NULL low rank updates will take the form \code{scale_perturb_factor * scale_perturb_factor.T}.}

\item{adjoint}{Logical indicating whether to use the scale matrix as specified or its adjoint.
Default value: FALSE.}

\item{validate_args}{Logical, default FALSE. Whether to validate input with asserts. If validate_args is
FALSE, and the inputs are invalid, correct behavior is not guaranteed.}

\item{name}{name prefixed to Ops created by this class.}

\item{dtype}{\code{tf$DType} to prefer when converting args to Tensors. Else, we fall back to a
common dtype inferred from the args, finally falling back to float32.}
}
\value{
a bijector instance.
}
\description{
This Bijector is initialized with shift Tensor and scale arguments,
giving the forward operation: \code{Y = g(X) = scale @ X + shift}
where the scale term is logically equivalent to:
\verb{scale = scale_identity_multiplier * tf.diag(tf.ones(d)) + tf.diag(scale_diag) + scale_tril + scale_perturb_factor @ diag(scale_perturb_diag) @ tf.transpose([scale_perturb_factor]))}
}
\details{
If NULL of \code{scale_identity_multiplier}, \code{scale_diag}, or \code{scale_tril} are specified then
\verb{scale += IdentityMatrix} Otherwise specifying a scale argument has the semantics of
\verb{scale += Expand(arg)}, i.e., \code{scale_diag != NULL} means \verb{scale += tf$diag(scale_diag)}.
}
\seealso{
For usage examples see \code{\link[=tfb_forward]{tfb_forward()}}, \code{\link[=tfb_inverse]{tfb_inverse()}}, \code{\link[=tfb_inverse_log_det_jacobian]{tfb_inverse_log_det_jacobian()}}.

Other bijectors: 
\code{\link{tfb_absolute_value}()},
\code{\link{tfb_affine_linear_operator}()},
\code{\link{tfb_affine_scalar}()},
\code{\link{tfb_ascending}()},
\code{\link{tfb_batch_normalization}()},
\code{\link{tfb_blockwise}()},
\code{\link{tfb_chain}()},
\code{\link{tfb_cholesky_outer_product}()},
\code{\link{tfb_cholesky_to_inv_cholesky}()},
\code{\link{tfb_correlation_cholesky}()},
\code{\link{tfb_cumsum}()},
\code{\link{tfb_discrete_cosine_transform}()},
\code{\link{tfb_expm1}()},
\code{\link{tfb_exp}()},
\code{\link{tfb_ffjord}()},
\code{\link{tfb_fill_scale_tri_l}()},
\code{\link{tfb_fill_triangular}()},
\code{\link{tfb_glow}()},
\code{\link{tfb_gompertz_cdf}()},
\code{\link{tfb_gumbel_cdf}()},
\code{\link{tfb_gumbel}()},
\code{\link{tfb_identity}()},
\code{\link{tfb_inline}()},
\code{\link{tfb_invert}()},
\code{\link{tfb_iterated_sigmoid_centered}()},
\code{\link{tfb_kumaraswamy_cdf}()},
\code{\link{tfb_kumaraswamy}()},
\code{\link{tfb_lambert_w_tail}()},
\code{\link{tfb_masked_autoregressive_default_template}()},
\code{\link{tfb_masked_autoregressive_flow}()},
\code{\link{tfb_masked_dense}()},
\code{\link{tfb_matrix_inverse_tri_l}()},
\code{\link{tfb_matvec_lu}()},
\code{\link{tfb_normal_cdf}()},
\code{\link{tfb_ordered}()},
\code{\link{tfb_pad}()},
\code{\link{tfb_permute}()},
\code{\link{tfb_power_transform}()},
\code{\link{tfb_rational_quadratic_spline}()},
\code{\link{tfb_rayleigh_cdf}()},
\code{\link{tfb_real_nvp_default_template}()},
\code{\link{tfb_real_nvp}()},
\code{\link{tfb_reciprocal}()},
\code{\link{tfb_reshape}()},
\code{\link{tfb_scale_matvec_diag}()},
\code{\link{tfb_scale_matvec_linear_operator}()},
\code{\link{tfb_scale_matvec_lu}()},
\code{\link{tfb_scale_matvec_tri_l}()},
\code{\link{tfb_scale_tri_l}()},
\code{\link{tfb_scale}()},
\code{\link{tfb_shifted_gompertz_cdf}()},
\code{\link{tfb_shift}()},
\code{\link{tfb_sigmoid}()},
\code{\link{tfb_sinh_arcsinh}()},
\code{\link{tfb_sinh}()},
\code{\link{tfb_softmax_centered}()},
\code{\link{tfb_softplus}()},
\code{\link{tfb_softsign}()},
\code{\link{tfb_split}()},
\code{\link{tfb_square}()},
\code{\link{tfb_tanh}()},
\code{\link{tfb_transform_diagonal}()},
\code{\link{tfb_transpose}()},
\code{\link{tfb_weibull_cdf}()},
\code{\link{tfb_weibull}()}
}
\concept{bijectors}
