% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hadoop_dataset.R
\name{sequence_file_dataset}
\alias{sequence_file_dataset}
\title{Create a \code{SequenceFileDataset}.}
\usage{
sequence_file_dataset(filenames)
}
\arguments{
\item{filenames}{A \code{tf.string} tensor containing one or more filenames.}
}
\description{
This function allows a user to read data from a hadoop sequence
file. A sequence file consists of (key value) pairs sequentially. At
the moment, \code{org.apache.hadoop.io.Text} is the only serialization type
being supported, and there is no compression support.
}
\examples{
\dontrun{
dataset <- sequence_file_dataset("testdata/string.seq") \%>\%
  dataset_repeat(1)

sess <- tf$Session()
iterator <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iterator)

until_out_of_range({
  batch <- sess$run(next_batch)
  print(batch)
})
}

}
