% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_estimator.R
\name{predict.tf_estimator}
\alias{predict.tf_estimator}
\title{Generate Predictions with an Estimator}
\usage{
\method{predict}{tf_estimator}(
  object,
  input_fn,
  checkpoint_path = NULL,
  predict_keys = c("predictions", "classes", "class_ids", "logistic", "logits",
    "probabilities"),
  hooks = NULL,
  as_iterable = FALSE,
  simplify = TRUE,
  yield_single_examples = TRUE,
  ...
)
}
\arguments{
\item{object}{A TensorFlow estimator.}

\item{input_fn}{An input function, typically generated by the \code{\link[=input_fn]{input_fn()}}
helper function.}

\item{checkpoint_path}{The path to a specific model checkpoint to be used for
prediction. If \code{NULL} (the default), the latest checkpoint in \code{model_dir}
is used.}

\item{predict_keys}{The types of predictions that should be produced, as an
\R list. When this argument is not specified (the default), all possible
predicted values will be returned.}

\item{hooks}{A list of \R functions, to be used as callbacks inside the
training loop. By default, \code{hook_history_saver(every_n_step = 10)} and
\code{hook_progress_bar()} will be attached if not provided to save the metrics
history and create the progress bar.}

\item{as_iterable}{Boolean; should a raw Python generator be returned? When
\code{FALSE} (the default), the predicted values will be consumed from the
generator and returned as an \R object.}

\item{simplify}{Whether to simplify prediction results into a \code{tibble},
as opposed to a list. Defaults to \code{TRUE}.}

\item{yield_single_examples}{(Available since TensorFlow v1.7) If \code{FALSE},
yields the whole batch as returned by the \code{model_fn} instead of decomposing
the batch into individual elements. This is useful if \code{model_fn} returns some
tensors with first dimension not equal to the batch size.}

\item{...}{Optional arguments passed on to the estimator's \code{predict()}
method.}
}
\description{
Generate predicted labels / values for input data provided by \code{input_fn()}.
}
\section{Yields}{
 Evaluated values of \code{predictions} tensors.
}

\section{Raises}{
 ValueError: Could not find a trained model in model_dir.
ValueError: if batch length of predictions are not same. ValueError: If
there is a conflict between \code{predict_keys} and \code{predictions}. For example
if \code{predict_keys} is not \code{NULL} but \code{EstimatorSpec.predictions} is not a
\code{dict}.
}

\seealso{
Other custom estimator methods: 
\code{\link{estimator_spec}()},
\code{\link{estimator}()},
\code{\link{evaluate.tf_estimator}()},
\code{\link{export_savedmodel.tf_estimator}()},
\code{\link{train.tf_estimator}()}
}
\concept{custom estimator methods}
