% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_line_dataset.R
\name{dataset_decode_delim}
\alias{dataset_decode_delim}
\title{Transform a dataset with delimted text lines into a dataset with named
columns}
\usage{
dataset_decode_delim(dataset, record_spec, parallel_records = NULL)
}
\arguments{
\item{dataset}{Dataset containing delimited text lines (e.g. a CSV)}

\item{record_spec}{Specification of column names and types (see \code{\link[=delim_record_spec]{delim_record_spec()}}).}

\item{parallel_records}{(Optional) An integer, representing the number of
records to decode in parallel. If not specified, records will be
processed sequentially.}
}
\description{
Transform a dataset with delimted text lines into a dataset with named
columns
}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_map}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
