% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{step_shared_embeddings_column}
\alias{step_shared_embeddings_column}
\title{Creates shared embeddings for categorical columns}
\usage{
step_shared_embeddings_column(
  spec,
  ...,
  dimension,
  combiner = "mean",
  initializer = NULL,
  shared_embedding_collection_name = NULL,
  ckpt_to_load_from = NULL,
  tensor_name_in_ckpt = NULL,
  max_norm = NULL,
  trainable = TRUE
)
}
\arguments{
\item{spec}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{...}{Comma separated list of variable names to apply the step. \link{selectors} can also be used.}

\item{dimension}{An integer specifying dimension of the embedding, must be > 0.
Can also be a function of the size of the vocabulary.}

\item{combiner}{A string specifying how to reduce if there are multiple entries in
a single row. Currently 'mean', 'sqrtn' and 'sum' are supported, with 'mean' the
default. 'sqrtn' often achieves good accuracy, in particular with bag-of-words
columns. Each of this can be thought as example level normalizations on
the column. For more information, see \code{tf.embedding_lookup_sparse}.}

\item{initializer}{A variable initializer function to be used in embedding
variable initialization. If not specified, defaults to
\code{tf.truncated_normal_initializer} with mean \code{0.0} and standard deviation
\code{1/sqrt(dimension)}.}

\item{shared_embedding_collection_name}{Optional collective name of
these columns. If not given, a reasonable name will be chosen based on
the names of categorical_columns.}

\item{ckpt_to_load_from}{String representing checkpoint name/pattern from
which to restore column weights. Required if \code{tensor_name_in_ckpt} is
not \code{NULL}.}

\item{tensor_name_in_ckpt}{Name of the Tensor in ckpt_to_load_from from which to
restore the column weights. Required if \code{ckpt_to_load_from} is not \code{NULL}.}

\item{max_norm}{If not \code{NULL}, embedding values are l2-normalized to this value.}

\item{trainable}{Whether or not the embedding is trainable. Default is \code{TRUE}.}
}
\value{
a \code{FeatureSpec} object.
}
\description{
This is similar to \link{step_embedding_column}, except that it produces a list of
embedding columns that share the same embedding weights.
}
\note{
Does not work in the eager mode.
}
\seealso{
\link{steps} for a complete list of allowed steps.

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{fit.FeatureSpec}()},
\code{\link{step_bucketized_column}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_file}()},
\code{\link{step_categorical_column_with_vocabulary_list}()},
\code{\link{step_crossed_column}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_numeric_column}()},
\code{\link{step_remove_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
