% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_normalization.R
\name{step_text_normalization}
\alias{step_text_normalization}
\alias{tidy.step_text_normalization}
\title{Normalization of Character Variables}
\usage{
step_text_normalization(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  normalization_form = "nfc",
  skip = FALSE,
  id = rand_id("text_normalization")
)
}
\arguments{
\item{recipe}{A \link[recipes:recipe]{recipes::recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{normalization_form}{A single character string determining the Unicode
Normalization. Must be one of "nfc", "nfd", "nfkd", "nfkc", or
"nfkc_casefold". Defaults to "nfc". See \code{\link[stringi:stri_trans_nf]{stringi::stri_trans_nfc()}} for
more details.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_text_normalization()} creates a \emph{specification} of a recipe step that
will perform Unicode Normalization on character variables.
}
\section{Tidying}{
When you \code{\link[recipes:tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{normalization_form}, and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{normalization_form}{character, type of normalization}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("stringi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)

sample_data <- tibble(text = c("sch\U00f6n", "scho\U0308n"))

rec <- recipe(~., data = sample_data) \%>\%
  step_text_normalization(text)

prepped <- rec \%>\%
  prep()

bake(prepped, new_data = NULL, text) \%>\%
  slice(1:2)

bake(prepped, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(text)

tidy(rec, number = 1)
tidy(prepped, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=step_texthash]{step_texthash()}} for feature hashing.
}
\concept{Steps for Text Normalization}
