% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_tokens.R
\name{show_tokens}
\alias{show_tokens}
\title{Show token output of recipe}
\usage{
show_tokens(rec, var)
}
\arguments{
\item{rec}{A recipe object}

\item{var}{name of variable}
}
\value{
A list of character vectors
}
\description{
Returns the tokens as a list of character vector of a recipe. This function
can be useful for diagnostics doing recipe construction but should not be
used in final recipe steps. Note that this function will both prep() and
bake() the recipe it is used on.
}
\examples{
text_tibble <- tibble(text = c("This is words", "They are nice!"))

recipe(~ text, data = text_tibble) \%>\%
  step_tokenize(text) \%>\%
  show_tokens(text)
}
