% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize.R
\name{step_tokenize}
\alias{step_tokenize}
\alias{tidy.step_tokenize}
\title{Tokenization of character variables}
\usage{
step_tokenize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  training_options = list(),
  options = list(),
  token = "words",
  engine = "tokenizers",
  custom_token = NULL,
  skip = FALSE,
  id = rand_id("tokenize")
)

\method{tidy}{step_tokenize}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For \code{\link[=step_tokenize]{step_tokenize()}}, this indicates the variables to be encoded
into a \link{tokenlist}. See \code{\link[recipes:selections]{recipes::selections()}} for more
details. For the \code{tidy} method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is \code{NULL} until the step is trained by
\code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{training_options}{A list of options passed to the tokenizer when it is
being trained. Only applicable for engine == "tokenizers.bpe".}

\item{options}{A list of options passed to the tokenizer.}

\item{token}{Unit for tokenizing. See details for options. Defaults to
"words".}

\item{engine}{Package that will be used for tokenization. See details for
options. Defaults to "tokenizers".}

\item{custom_token}{User supplied tokenizer. Use of this argument
will overwrite the token and engine arguments. Must take a character vector
as input and output a list of character vectors.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all
operations are baked when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using \code{skip = TRUE} as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it}

\item{x}{A \code{step_tokenize} object.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{\link[=step_tokenize]{step_tokenize()}} creates a \emph{specification} of a recipe step that
will convert a character predictor into a \link{tokenlist}.
}
\details{
Tokenization is the act of splitting a character string into smaller parts
to be further analysed. This step uses the \code{tokenizers} package which
includes heuristics to split the text into paragraphs tokens, word tokens
amoug others. \code{textrecipes} keeps the tokens in a \link{tokenlist} and other
steps will do their tasks on those \link{tokenlist}s before transforming them
back to numeric.

The choice of \code{engine} determines the possible choices of \code{token}.

If \code{engine = "tokenizers"}:
\itemize{
\item "words" (default)
\item "characters"
\item "character_shingles"
\item "ngrams"
\item "skip_ngrams"
\item "sentences"
\item "lines"
\item "paragraphs"
\item "regex"
\item "tweets"
\item "ptb" (Penn Treebank)
\item "skip_ngrams"
\item "word_stems"
}

if \code{engine = "spacyr"}
\itemize{
\item "words"
}

Working will \code{textrecipes} will almost always start by calling
\code{step_tokenize} followed by modifying and filtering steps. This is not always
the case as you sometimes want to do apply pre-tokenization steps, this can
be done with \code{\link[recipes:step_mutate]{recipes::step_mutate()}}.
}
\examples{
library(recipes)
library(modeldata)
data(okc_text)

okc_rec <- recipe(~., data = okc_text) \%>\%
  step_tokenize(essay0)

okc_obj <- okc_rec \%>\%
  prep()

bake(okc_obj, new_data = NULL, essay0) \%>\%
  slice(1:2)

bake(okc_obj, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(essay0)

tidy(okc_rec, number = 1)
tidy(okc_obj, number = 1)

okc_obj_chars <- recipe(~., data = okc_text) \%>\%
  step_tokenize(essay0, token = "characters") \%>\%
  prep()

bake(okc_obj, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(essay0)
}
\seealso{
\code{\link[=step_untokenize]{step_untokenize()}} to untokenize.
}
\concept{character to tokenlist steps}
