% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemma.R
\name{step_lemma}
\alias{step_lemma}
\alias{tidy.step_lemma}
\title{Lemmatization of \link{tokenlist} variables}
\usage{
step_lemma(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("lemma")
)

\method{tidy}{step_lemma}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For \code{step_lemma}, this indicates the variables to be encoded
into a \link{tokenlist}. See \code{\link[recipes:selections]{recipes::selections()}} for more
details. For the \code{tidy} method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is \code{NULL} until the step is trained by
\code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all
operations are baked when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using \code{skip = TRUE} as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_lemma} object.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_lemma} creates a \emph{specification} of a recipe step that
will extract the lemmatization of a tokenlist.
}
\details{
This stem doesn't perform lemmatization by itself, but rather lets you
extract the lemma attribute of the tokenlist. To be able to use \code{step_lemma}
you need to use a tokenization method that includes lemmatization. Currently
using the \code{"spacyr"} engine in \code{\link[=step_tokenize]{step_tokenize()}} provides lemmatization and
works well with \code{step_lemma}.
}
\examples{
\dontrun{
library(recipes)

short_data <- data.frame(text = c("This is a short tale,",
                                  "With many cats and ladies."))

okc_rec <- recipe(~ text, data = short_data) \%>\%
  step_tokenize(text, engine = "spacyr") \%>\%
  step_lemma(text) \%>\%
  step_tf(text)
  
okc_obj <- prep(okc_rec)
  
juice(okc_obj)
}
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn character into tokenlist.

Other tokenlist to tokenlist steps: 
\code{\link{step_ngram}()},
\code{\link{step_pos_filter}()},
\code{\link{step_stem}()},
\code{\link{step_stopwords}()},
\code{\link{step_tokenfilter}()},
\code{\link{step_tokenmerge}()}
}
\concept{tokenlist to tokenlist steps}
