% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{text_intersect}
\alias{text_intersect}
\title{intersection of words or letters in tokenized text}
\usage{
# utl <- text_intersect$new(token_list1 = NULL, token_list2 = NULL)
}
\value{
a numeric vector
}
\description{
intersection of words or letters in tokenized text

intersection of words or letters in tokenized text
}
\details{
This class includes methods for text or character intersection. If both \emph{distinct} and \emph{letters} are FALSE then the simple (count or ratio) word intersection will be computed.
}
\section{Methods}{


\describe{
 \item{\code{text_intersect$new(file_data = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{count_intersect(distinct = FALSE, letters = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{ratio_intersect(distinct = FALSE, letters = FALSE)}}{}
 }
}

\examples{

library(textTinyR)

tok1 = list(c('compare', 'this', 'text'),

            c('and', 'this', 'text'))

tok2 = list(c('with', 'another', 'set'),

            c('of', 'text', 'documents'))


init = text_intersect$new(tok1, tok2)


init$count_intersect(distinct = TRUE, letters = FALSE)


init$ratio_intersect(distinct = FALSE, letters = TRUE)
}
\references{
https://www.kaggle.com/c/home-depot-product-search-relevance/discussion/20427 by Igor Buinyi
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{text_intersect$new()}}
\item \href{#method-count_intersect}{\code{text_intersect$count_intersect()}}
\item \href{#method-ratio_intersect}{\code{text_intersect$ratio_intersect()}}
\item \href{#method-clone}{\code{text_intersect$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{text_intersect$new(token_list1 = NULL, token_list2 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token_list1}}{a list, where each sublist is a tokenized text sequence (\emph{token_list1} should be of same length with \emph{token_list2})}

\item{\code{token_list2}}{a list, where each sublist is a tokenized text sequence (\emph{token_list2} should be of same length with \emph{token_list1})}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-count_intersect"></a>}}
\if{latex}{\out{\hypertarget{method-count_intersect}{}}}
\subsection{Method \code{count_intersect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{text_intersect$count_intersect(distinct = FALSE, letters = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distinct}}{either TRUE or FALSE. If TRUE then the intersection of \emph{distinct} words (or letters) will be taken into account}

\item{\code{letters}}{either TRUE or FALSE. If TRUE then the intersection of letters in the text sequences will be computed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ratio_intersect"></a>}}
\if{latex}{\out{\hypertarget{method-ratio_intersect}{}}}
\subsection{Method \code{ratio_intersect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{text_intersect$ratio_intersect(distinct = FALSE, letters = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distinct}}{either TRUE or FALSE. If TRUE then the intersection of \emph{distinct} words (or letters) will be taken into account}

\item{\code{letters}}{either TRUE or FALSE. If TRUE then the intersection of letters in the text sequences will be computed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{text_intersect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
