% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_bns.R
\docType{data}
\name{BNS}
\alias{BNS}
\title{BNS}
\format{\code{\link{R6Class}} object.}
\usage{
BNS
}
\description{
Creates BNS (bi-normal separation) model.
Defined as: Q(true positive rate) - Q(false positive rate), where Q is a quantile function of normal distribution.
}
\details{
Bi-Normal Separation
}
\section{Fields}{

\describe{
\item{\code{bns_stat}}{\code{data.table} with computed BNS statistic.
Useful for feature selection.}
}}

\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
bns = BNS$new(treshold = 0.0005)
bns$fit_transform(x, y)
bns$transform(x)
}
}

\section{Methods}{

\describe{
  \item{\code{$new(treshold = 0.0005)}}{Creates bns model}
  \item{\code{$fit_transform(x, y)}}{fit model to an input sparse matrix (preferably in "dgCMatrix"
   format) and then transforms it.}
  \item{\code{$transform(x)}}{transform new data \code{x} using bns from train data}
}
}

\section{Arguments}{

\describe{
 \item{bns}{A \code{BNS} object}
 \item{x}{An input document term matrix. Preferably in \code{dgCMatrix} format}
 \item{y}{Binary target variable coercible to logical.}
 \item{treshold}{Clipping treshold to avoid infinities in quantile function.}
}
}

\examples{
data("movie_review")
N = 1000
it = itoken(head(movie_review$review, N), preprocessor = tolower, tokenizer = word_tokenizer)
vocab = create_vocabulary(it)
dtm = create_dtm(it, vocab_vectorizer(vocab))
model_bns = BNS$new()
dtm_bns = model_bns$fit_transform(dtm, head(movie_review$sentiment, N))
}
\keyword{datasets}
