% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{itoken}
\alias{itoken}
\alias{itoken.character}
\alias{itoken.ifiles}
\alias{itoken.ilines}
\alias{itoken.iserfiles}
\title{Creates iterator over input object.}
\usage{
itoken(iterable, ...)

\method{itoken}{character}(iterable, preprocess_function, tokenizer,
  chunks_number = 10, progessbar = interactive(), ...)

\method{itoken}{ifiles}(iterable, preprocess_function, tokenizer,
  progessbar = interactive(), ...)

\method{itoken}{iserfiles}(iterable, progessbar = interactive(), ...)

\method{itoken}{ilines}(iterable, preprocess_function, tokenizer, ...)
}
\arguments{
\item{iterable}{an object from which to generate an iterator.}

\item{...}{arguments passed to other methods (not used at the moment).}

\item{preprocess_function}{\code{function} which takes chunk of objects -
\code{character vector} and \bold{do all preprocessing} (including stemming if needed).
Usually \code{preprocess_function} should return \code{character vector} - vector of
preprocessed/cleaned documents. See "Details" section.}

\item{tokenizer}{\code{function} which takes \code{character vector}
from preprocess_function, split it into tokens and returns
\code{list} of \code{character vector}s.
Also you can perform tokenization in \code{preprocess_function}
(actually you should do it when apply any stemming) and then set
\code{tokenizer} = \code{\link{identity}}.}

\item{chunks_number}{\code{integer}, the number of pieces that object should be divided into.}

\item{progessbar}{\code{logical} indicates whether to show progress bar.}
}
\description{
Creates iterator over input object. This iterator usually used in
following functions : \link{vocabulary}, \link{create_vocab_corpus},
\link{create_hash_corpus}. See them for details.
}
\examples{
data("movie_review")
txt <- movie_review[['review']][1:100]
it <- itoken(txt, tolower, word_tokenizer, chunks_number = 7)
}
\seealso{
\link{vocabulary}, \link{create_vocab_corpus}, \link{create_hash_corpus}
}

