% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,multinom-method}
\alias{extract,multinom-method}
\alias{extract.multinom}
\title{\code{\link{extract}} method for \code{multinom} objects}
\usage{
\S4method{extract}{multinom}(
  model,
  include.pvalues = TRUE,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.deviance = TRUE,
  include.nobs = TRUE,
  include.groups = TRUE,
  levels = model$lev,
  beside = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.pvalues}{Report p-values?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.deviance}{Report the deviance?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.groups}{Report the number of groups?}

\item{levels}{The names of the levels of a multinomial model that should be
included in the table. Should be provided as a vector of character strings.}

\item{beside}{Arrange the model terms below each other or beside each other?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{multinom} objects created by the
\code{\link[nnet]{multinom}} function in the \pkg{nnet} package.
}
