% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.evmSim.R
\name{plot.evmSim}
\alias{plot.evmSim}
\title{Plots for evmSim objects}
\usage{
\method{plot}{evmSim}(x, which.plots = 1:3, density.adjust = 2,
  print.seed = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{evmSim}}

\item{which.plots}{Which plots to produce. Option 1 gives kernel
density estimates, 2 gives traces of the Markov chains with
superimposed cumulative means, 3 gives autocorrelation
functions.}

\item{density.adjust}{In \code{plot} method for class
\code{evmSim}.  Passed into \code{density}. Controls the amount
of smoothing of the kernel density estimate.}

\item{print.seed}{Whether or not to print the seed used in the
simulations, or to annotate the plots with it.}

\item{...}{ignored}
}
\description{
This function produces diagnostic plots for the Markov chains used
to simulate from the posterior distributions for the model
parameters. If the chains have converged on the posterior
distributions, the trace plots should look like
"fat hairy caterpillars" and their cumulative means should converge
rapidly. Moreover, the autocorrelation functions should converge
quickly to zero.
}
\seealso{
\code{\link{evm}}

\code{\link[stats]{density}}
}
