% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texmex-package.R
\docType{package}
\name{texmex-package}
\alias{texmex}
\alias{texmex-package}
\title{Extreme value modelling}
\description{
Extreme values modelling, including the conditional multivariate approach of
Heffernan and Tawn (2004).
}
\details{
\tabular{ll}{ Package: \tab mex\cr Type: \tab Package\cr Version: \tab
2.3\cr Date: \tab 2014-03-03\cr License: \tab GPL (>=2) | BSD\cr } The
packages was originally called `texmex' for Threshold EXceedances and
Multivariate EXtremes. However, it is no longer the case that only threshold
excess models are implemented, so the `tex' bit doesn't make sense. So, the
package is called `texmex' because it used to be called `texmex'.

\code{\link{evm}}: Fit extreme value distributions to data, possibly with
covariates. Use maximum likelihood estimation, maximum penalized likelihood
estimation, simulate from the posterior distribution or run a parametric
bootstrap. Extreme value families include the generalized Pareto
distribution (\code{gpd}) and generalized extreme value (\code{gev})
distribution.

\code{\link{mex}}: Fit multiple, independent generalized Pareto models to
the the upper tails of the columns of a data set, and estimate the
conditional dependence structure between the columns using the method of
Heffernan and Tawn.

\code{\link{bootmex}}: Bootstrap estimation for parameters in generalized
Pareto models and in the dependence structure.

\code{\link{declust}}: Estimation of extremal index and subsequent
declustering of dependent sequences using the intervals estimator of Ferro
and Segers.
}
\examples{

# Analyse the winter data used by Heffernan and Tawn
mymex <- mex(winter, mqu = .7, penalty="none", dqu=.7, which = "NO")
plot(mymex)
# Only do 10 replicates to keep CRAN checks happy. Do many more in any
# real application
myboot <- bootmex(mymex, R=10)
plot(myboot)
mypred <- predict(myboot,  pqu=.95)
summary(mypred , probs = c( .025, .5, .975 ))

# Analyse the liver data included in the package
#library(MASS) # For the rlm function

#liver <- liver[liver$ALP.M > 1,] # Get rid of outlier
#liver$ndose <- as.numeric(liver$dose)

#alt <- resid(rlm(log(ALT.M) ~ log(ALT.B) + ndose, data=liver, method="MM"))
#ast <- resid(rlm(log(AST.M) ~ log(AST.B) + ndose, data=liver, method="MM"))
#alp <- resid(rlm(log(ALP.M) ~ log(ALP.B) + ndose, data=liver, method="MM"))
#tbl <- resid(rlm(log(TBL.M) ~ log(TBL.B) + ndose, data=liver, method="MM"))

#r <- data.frame(alt=alt, ast=ast, alp=alp, tbl=tbl)

#Amex <- mex(r[liver$dose == "A",], mqu=.7)
#Bmex <- mex(r[liver$dose == "B",], mqu=.7)
#Cmex <- mex(r[liver$dose == "C",], mqu=.7)
#Dmex <- mex(r[liver$dose == "D",], mqu=.7)

#par(mfcol=c(3,3))
#plot(Amex)

#plot(Dmex, col="blue")

## Take a closer look at the marginal behaviour of ALT
# Lines commented out to keep CRAN checks short

#r$ndose <- liver$ndose

#altmod1 <- evm(alt, qu=.7, phi = ~ ndose, xi = ~ ndose, data=r)
#altmod2 <- evm(alt, qu=.7, phi = ~ ndose, data=r)
#altmod3 <- evm(alt, qu=.7, xi = ~ ndose, data=r)
#altmod4 <- evm(alt, qu=.7, data=r)

# Prefer model 3, with term for xi on basis of AIC

#balt3 <- evm(alt, qu=.7, xi = ~ ndose, data=r, method="simulate")
#par(mfrow=c(3,3))
#plot(balt3)

# use longer burn-in and also thin the output

#balt3 <- thinAndBurn(balt3,burn=1000,thin=5)
#plot(balt3)

# Get some simulated values for dose D

#DParam <- predict(balt3,type="lp",newdata=data.frame(ndose=4),all=TRUE)$obj$link[[1]]

#simD <- rgpd(nrow(DParam), sigma=exp(DParam[,"phi"]), xi=DParam[,"xi"], u=quantile(alt, .7))

# These are simulated residuals. Get some baselines and transform all
# to raw scale

#b <- sample(log(liver$ALT.M), size=nrow(balt3$param), replace=TRUE)
#res <- exp(b + simD)

# estimate quantiles on raw scale
#quantile(res, prob=c(.5, .75, .9, .95, .99))

# estimate proportion exceeding 3*upper limit of normal mean(res >
# 36 * 3) # 36 is the upper limit of normal for ALT
}
\author{
Harry Southworth, Janet E. Heffernan

Maintainer: Harry Southworth <harry.southworth@gmail.com>

URL: https://github.com/harrysouthworth/texmex
}
\references{
J. E. Heffernan and J. A. Tawn, A conditional approach for
multivariate extreme values, Journal of the Royal Statistical society B, 66,
497 -- 546, 2004.

C.A.T Ferro and J. Segers, Inference for Clusters of Extreme Values, Journal
of the Royal Statistical society B, 65, 545 -- 556, 2003.
}
\keyword{models}
\keyword{multivariate}
\keyword{package}

