% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texPreview.R
\name{texPreview}
\alias{texPreview}
\title{Render and Preview snippets of TeX in R Viewer}
\usage{
texPreview(obj, stem, fileDir = NULL, overwrite = T, margin = list(left =
  10, top = 5, right = 50, bottom = 5), imgFormat = "png",
  print.xtable.opts = list(), returnType = "viewer",
  opts.html = list(width = "100\%", height = "100\%"), usrPackages = NULL,
  engine = c("pdflatex", "xelatex", "lualatex"), ...)
}
\arguments{
\item{obj}{character, TeX script}

\item{stem}{character, name to use in output files}

\item{fileDir}{character, output destination. If NULL a temp.dir() will be used and no output will be saved}

\item{overwrite}{logical, controls if overwriting of output stem* files given their existences}

\item{margin}{table margin for pdflatex call}

\item{imgFormat}{character, defines the type of image the PDF is converted to.}

\item{print.xtable.opts}{list containing arguments to pass to print.table, relevant only if xtable is used as the input}

\item{returnType}{one of "viewer", "html", or "tex" determining appropriate return type for the rendering process}

\item{opts.html}{a list of html options, currently height and width.  can be specified as percentage or pixels.}

\item{usrPackages}{character of usepackage commands, see details for string format}

\item{engine}{character specifies which latex to pdf engine to use ('pdflatex' default,'xelatex','lualatex')}

\item{...}{passed to \code{system}}
}
\description{
input TeX script into the function and it renders a pdf and converts it an image which is sent to Viewer.
}
\details{
The function assumes the system has pdflatex installed and it is defined in the PATH. The function does not return anything to R.
If fileDir is specified then two files are written to the directory. An image file of the name stem with the extension specified in imgFormat.
The default extension is png.The second file is the TeX script used to create the output of the name stem.tex.   If you do not wish to view the 
console output, pass the corresponding arguments to \code{...}, e.g., ignore.stdout=T.
usrPackage accepts a vector of character strings built by the function \code{\link{buildUsepackage}}, of the form
 \\\\usepackage[option1,option2,...]\{package_name\}, see the TeX wikibook for more information \url{https://en.wikibooks.org/wiki/LaTeX/Document_Structure#Packages}.
}
\examples{
data('iris')
\donttest{
if(interactive()){
texPreview(obj = xtable::xtable(head(iris,10)),stem = 'eq',imgFormat = 'svg')

\dontrun{
tex='\\\\begin{tabular}{llr}
\\\\hline
\\\\multicolumn{2}{c}{Item} \\\\\\\\
\\\\cline{1-2}
Animal    & Description & Price (\\\\$) \\\\\\\\
\\\\hline
Gnat      & per gram    & 13.65      \\\\\\\\
& each        & 0.01       \\\\\\\\
Gnu       & stuffed     & 92.50      \\\\\\\\
Emu       & stuffed     & 33.33      \\\\\\\\
Armadillo & frozen      & 8.99       \\\\\\\\
\\\\hline
\\\\end{tabular}'

texPreview(obj = tex,stem = 'eq',imgFormat = 'svg')

tikzEx=readLines('http://www.texample.net/media/tikz/examples/TEX/credit-rationing.tex')
usetikz=paste(tikzEx[14:23],collapse="\\n")
bodytikz=paste(tikzEx[25:90],collapse="\\n")

texPreview(obj = bodytikz,
stem='tikzTest',imgFormat = 'svg',
usrPackages = buildUsepackage(pkg = 'tikz',uselibrary = usetikz))
}
}
}
}
