% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-that.R
\name{expect_that}
\alias{expect_that}
\title{Expect that a condition holds.}
\usage{
expect_that(object, condition, info = NULL, label = NULL)
}
\arguments{
\item{object}{object to test}

\item{condition, }{a function that returns whether or not the condition
is met, and if not, an error message to display.}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}
}
\value{
the (internal) expectation result as an invisible list
}
\description{
An old style of testing that's no longer encouraged.
}
\examples{
expect_that(5 * 2, equals(10))
expect_that(sqrt(2) ^ 2, equals(2))
\dontrun{
expect_that(sqrt(2) ^ 2, is_identical_to(2))
}
}
\seealso{
\code{\link[=fail]{fail()}} for an expectation that always fails.
}
\keyword{internal}
