% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation_rule.R
\name{imputation_rule}
\alias{imputation_rule}
\title{Apply 1/3 or 1/2 Imputation Rule to Data}
\usage{
imputation_rule(
  df,
  x_stats,
  stat,
  imp_rule,
  post = FALSE,
  avalcat_var = "AVALCAT1"
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{x_stats}{(\verb{named list})\cr a named list of statistics, typically the results of \code{\link[=s_summary]{s_summary()}}.}

\item{stat}{(\code{character})\cr statistic to return the value/NA level of according to the imputation
rule applied.}

\item{imp_rule}{(\code{character})\cr imputation rule setting. Set to \code{"1/3"} to implement 1/3 imputation
rule or \code{"1/2"} to implement 1/2 imputation rule.}

\item{post}{(\code{flag})\cr whether the data corresponds to a post-dose time-point (defaults to \code{FALSE}).
This parameter is only used when \code{imp_rule} is set to \code{"1/3"}.}

\item{avalcat_var}{(\code{character})\cr name of variable that indicates whether a row in \code{df} corresponds
to an analysis value in category \code{"BLQ"}, \code{"LTR"}, \code{"<PCLLOQ"}, or none of the above
(defaults to \code{"AVALCAT1"}). Variable \code{avalcat_var} must be present in \code{df}.}
}
\value{
A \code{list} containing statistic value (\code{val}) and NA level (\code{na_str}) that should be displayed
according to the specified imputation rule.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
set.seed(1)
df <- data.frame(
  AVAL = runif(50, 0, 1),
  AVALCAT1 = sample(c(1, "BLQ"), 50, replace = TRUE)
)
x_stats <- s_summary(df$AVAL)
imputation_rule(df, x_stats, "max", "1/3")
imputation_rule(df, x_stats, "geom_mean", "1/3")
imputation_rule(df, x_stats, "mean", "1/2")

}
\seealso{
\code{\link[=analyze_vars_in_cols]{analyze_vars_in_cols()}} where this function can be implemented by setting the \code{imp_rule}
argument.
}
