\name{termstrc-package}
\alias{termstrc-package}
\alias{termstrc}
\docType{package}


\title{
Zero-coupon Yield Curve Estimation
}


\description{
The package offers a wide range of functions for term structure estimation based on static and dynamic coupon bond and yield data sets. The implementation focuses on the cubic splines approach of McCulloch (1971, 1975) and the Nelson and Siegel (1987) method with extensions by Svensson (1994), Diebold and Li (2006) and De Pooter (2007). We propose a weighted constrained optimization procedure with analytical gradients and a globally optimal start parameter search algorithm. Extensive summary statistics and plots are provided to compare the results of the different estimation methods. Several demos are available using data from European government bonds and yields. 

}

\references{

Robert Ferstl and Josef Hayden (2010):
Zero-Coupon Yield Curve Estimation with the Package \pkg{termstrc},
\emph{Journal of Statistical Software}, \bold{36(1)}, 1-34.
URL http://www.jstatsoft.org/v36/i01/

J. Huston McCulloch (1971):
Measuring the Term Structure of Interest Rates.
\emph{The Journal of Business, \bold{44} 19--31}. 

J. Huston McCulloch (1975):
The Tax-Adjusted Yield Curve.
\emph{The Journal of Finance, \bold{30} 811--830}. 

Charles R. Nelson and Andrew F. Siegel (1987): 
Parsimonious Modeling of Yield Curves.
\emph{The Journal of Business}, \bold{60(4)}:473--489.

Lars E.O. Svensson (1994): 
Estimating and Interpreting Forward Interest Rates: Sweden 1992 -1994. 
\emph{Technical Reports 4871, National Bureau of Economic Research}. 

Robert R. Bliss (1997):
Testing Term Structure Estimation Methods.
\emph{Advances in Futures and Options Research, \bold{9} 197--232}. 

Bank for International Settlements (2005):
Zero-Coupon Yield Curves: Technical Documentation.
\emph{BIS Papers, \bold{No. 25}}.

F.X. Diebold and C. Li (2006): Forecasting the Term Structure of Government Bond Yields. \emph{Journal 
of Econometrics}, \bold{130}:337--364.

Michiel De Pooter (2007): Examining the Nelson-Siegel Class of Term Structure Models: In-Sample Fit versus Out-of-Sample Forecasting Performance,
\emph{Working paper}.
 
}

\keyword{package}
