\name{termstrc-package}
\alias{termstrc-package}
\alias{termstrc}
\docType{package}


\title{
Zero-coupon Yield Curve Estimation
}


\description{
The package offers parametric and spline-based methods for the estimation of zero-coupon yield curves out of observed coupon bond data and zero yields. The methods include Nelson and Siegel (1987), Svensson (1994), Diebold/Li (2006) and the cubic splies approach of McCulloch (1975). Functions for the iterative estimation of the term structue based on a dynamic bond or yield data set are included. Extensive summary statistics and plots are provided to compare the results of the different estimation methods.

}

\references{

J. Huston McCulloch (1971):
Measuring the Term Structure of Interest Rates.
\emph{The Journal of Business, \bold{44} 19--31}. 

J. Huston McCulloch (1975):
The Tax-Adjusted Yield Curve.
\emph{The Journal of Finance, \bold{30} 811--830}. 

Charles R. Nelson and Andrew F. Siegel (1987): 
Parsimonious Modeling of Yield Curves.
\emph{The Journal of Business}, \bold{60(4)}:473--489.

Lars E.O. Svensson (1994): 
Estimating and Interpreting Forward Interest Rates: Sweden 1992 -1994. 
\emph{Technical Reports 4871, National Bureau of Economic Research}. 

Robert R. Bliss (1997):
Testing Term Structure Estimation Methods.
\emph{Advances in Futures and Options Research, \bold{9} 197--232}. 

Bank for International Settlements (2005).
Zero-Coupon Yield Curves: Technical Documentation.
\emph{BIS Papers, \bold{No. 25}}.

F.X. Diebold and C. Li (2006): Forecasting the Term Structure of Government Bond Yields. \emph{Journal 
of Econometrics}, \bold{130}:337--364.

Michiel De Pooter (2007): Examining the Nelson-Siegel Class of Term Structure Models: In-Sample Fit versus Out-of-Sample Forecasting Performance,
\emph{Working paper}.
 
}

\keyword{package}
