% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tergm.R
\name{tergm}
\alias{tergm}
\title{Temporal Exponential-Family Random Graph Models}
\usage{
tergm(
  formula,
  constraints = ~.,
  estimate,
  times = NULL,
  offset.coef = NULL,
  targets = NULL,
  target.stats = NULL,
  SAN.offsets = NULL,
  eval.loglik = NVL(getOption("tergm.eval.loglik"), getOption("ergm.eval.loglik")),
  control = control.tergm(),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{formula}{an ERGM formula.}

\item{constraints}{A formula specifying one or more constraints
on the support of the distribution of the networks being modeled. Multiple constraints
may be given, separated by \dQuote{+} and \dQuote{-} operators. See
\code{\link{ergmConstraint}} for the detailed explanation of
their semantics and also for an indexed list of the constraints visible to the \CRANpkg{ergm} package.

The default is to have no constraints except those provided through
the \code{\link{ergmlhs}} API.

Together with the model terms in the formula and the reference measure, the constraints
define the distribution of networks being modeled.

It is also possible to specify a proposal function directly either
by passing a string with the function's name (in which case,
arguments to the proposal should be specified through the
\code{MCMC.prop.args} argument to the relevant control function, or
by giving it on the LHS of the hints formula to \code{MCMC.prop}
argument to the control function. This will override
the one chosen automatically.

Note that not all possible combinations of constraints and reference
measures are supported. However, for relatively simple constraints
(i.e., those that simply permit or forbid specific dyads or sets of
dyads from changing), arbitrary combinations should be possible.}

\item{estimate}{One of "EGMME" for Equilibrium Generalized Method of Moments
Estimation, based on a single network with some temporal information and
making an assumption that it is a product of a TERGM process running to its
stationary (equilibrium) distribution; "CMLE" for Conditional Maximum
Likelihood Estimation, modeling a transition between two networks, or
"CMPLE" for Conditional Maximum PseudoLikelihood Estimation, using MPLE
instead of MLE.  CMPLE is extremely inaccurate at this time.}

\item{times}{For CMLE and CMPLE estimation, times or indexes at
which the networks whose transition is to be modeled are
observed. Default to \code{c(0,1)} if \code{nw} is a
\code{\link[networkDynamic]{networkDynamic}} and to
\code{1:length(nw)} (all transitions) if \code{nw} is a
\code{\link{network.list}} or a \code{\link{list}}. Unused for
EGMME. Note that at this time, the selected time points will be
treated as temporally adjacent. Irregluarly spaced time series
are not supported at this time.}

\item{offset.coef}{Numeric vector to specify offset parameters.}

\item{targets}{One-sided \code{\link{ergm}}-style formula specifying
statistics whose moments are used for the EGMME. Unused for CMLE and CMPLE.
Targets is required for EGMME estimation. It may contain any valid ergm
terms.  Any offset terms are used only during the
preliminary SAN run; they are removed automatically for the EGMME proper.
If \code{targets} is specified as a character
(one of \code{"formation"} and \code{"dissolution"}) then
the function \code{\link{.extract.fd.formulae}} is used to determine the
corresponding formula; the user should be aware of its behavior and limitations.}

\item{target.stats}{A vector specifying the values of the \code{targets}
statistics that EGMME will try to match.  Defaults to the statistics of
\code{nw}. Unused for CMLE and CMPLE.}

\item{SAN.offsets}{Offset coefficients (if any) to use during the SAN run.}

\item{eval.loglik}{Whether or not to calculate the log-likelihood
of a CMLE TERGM fit. See \code{\link{ergm}} for details. Can be
set globally via \code{option(tergm.eval.loglik=...)}, falling back to
\code{getOption("ergm.eval.loglik")} if not set.}

\item{control}{A list of control parameters for algorithm tuning.
Constructed using \code{\link{control.tergm}}.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{\dots}{Additional arguments, to be passed to lower-level functions.}
}
\value{
\code{\link{tergm}} returns an object of class \code{tergm} that
inherits from \code{ergm} and has the usual methods (\code{\link[=coef.ergm]{coef.ergm()}},
\code{\link[=summary.ergm]{summary.ergm()}}, \code{\link[=mcmc.diagnostics]{mcmc.diagnostics()}}, etc.) implemented for
it. Note that \code{\link[=gof]{gof()}} only works for the CMLE method.
}
\description{
\code{\link{tergm}} is used for finding Temporal ERGMs' (TERGMs) and Separable Temporal ERGMs' (STERGMs)
Conditional MLE (CMLE) (Krivitsky and Handcock, 2010) and Equilibrium
Generalized Method of Moments Estimator (EGMME) (Krivitsky, 2009).
}
\details{
\strong{Model Terms} See \code{\link{ergm}} and \code{\link{ergm-terms}} for
details. At this time, only linear ERGM terms are allowed.  \itemize{
\item For a brief demonstration, please see the tergm package vignette:
\code{browseVignettes(package='tergm')} \item A more detailed tutorial is
available on the statnet wiki:
\url{https://statnet.org/Workshops/tergm/tergm_tutorial.html} }
}
\examples{
\dontrun{
# EGMME Example
par(ask=FALSE)
n<-30
g0<-network.initialize(n,dir=FALSE)

#                     edges, degree(1), mean.age
target.stats<-c(      n*1/2,    n*0.6,        20)

dynfit<-tergm(g0 ~ Form(~edges + degree(1)) + Diss(~edges),
               targets = ~edges+degree(1)+mean.age,
               target.stats=target.stats, estimate="EGMME",
               control=control.tergm(SA.plot.progress=TRUE))

par(ask=TRUE)
mcmc.diagnostics(dynfit)
summary(dynfit)
}
\donttest{
# CMLE Example
data(samplk)

# Fit a transition from Time 1 to Time 2
samplk12 <- tergm(list(samplk1, samplk2)~
                  Form(~edges+mutual+transitiveties+cyclicalties)+
                  Diss(~edges+mutual+transitiveties+cyclicalties),
                  estimate="CMLE")

mcmc.diagnostics(samplk12)
summary(samplk12)

samplk12.gof <- gof(samplk12)

samplk12.gof

plot(samplk12.gof)

plot(samplk12.gof, plotlogodds=TRUE)

# Fit a transition from Time 1 to Time 2 and from Time 2 to Time 3 jointly
samplk123 <- tergm(list(samplk1, samplk2, samplk3)~
                   Form(~edges+mutual+transitiveties+cyclicalties)+
                   Diss(~edges+mutual+transitiveties+cyclicalties),
                   estimate="CMLE")

mcmc.diagnostics(samplk123)
summary(samplk123)
}

}
\references{
Krackhardt, D and Handcock, MS (2006) Heider vs Simmel: Emergent
features in dynamic structures.  ICML Workshop on Statistical
Network Analysis. Springer, Berlin, Heidelberg, 2006.

Hanneke S, Fu W, and Xing EP (2010). Discrete
Temporal Models of Social Networks. \emph{Electronic Journal of Statistics},
2010, 4, 585-605.
\doi{10.1214/09-EJS548}

Krivitsky P.N. and Handcock M.S. (2014) A Separable Model for Dynamic Networks. \emph{Journal of the Royal Statistical Society, Series B}, 76(1): 29-46. \doi{10.1111/rssb.12014}

Krivitsky, P.N. (2012). Modeling of Dynamic Networks based on
Egocentric Data with Durational Information. \emph{Pennsylvania State
University Department of Statistics Technical Report}, 2012(2012-01).
\url{http://stat.psu.edu/research/technical-report-files/2012-technical-reports/modeling-of-dynamic-networks-based-on-egocentric-data-with-durational-information}
}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link[=network]{network()}}, \code{\link{\%v\%}}, \code{\link{\%n\%}}, \code{\link{ergm-terms}}
}
