% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.statistics.networkDynamic.R
\name{summary_formula.networkDynamic}
\alias{summary_formula.networkDynamic}
\alias{summary.formula}
\title{Calculation of networkDynamic statistics.}
\usage{
\method{summary_formula}{networkDynamic}(object, at, ..., basis = NULL)
}
\arguments{
\item{object}{An \code{\link{formula}} object with a
\code{\link{networkDynamic}} as its LHS. (See
\code{\link[ergm]{summary_formula}} for more details.)}

\item{at}{A vector of time points at which to calculate the
statistics.}

\item{\dots}{Further arguments passed to or used by methods.}

\item{basis}{An optional \code{\link{networkDynamic}} object
relative to which the statistics should be calculated.}
}
\value{
A matrix with \code{length(at)} rows, one for each time
point in \code{at}, and columns for each term of the formula,
containing the corresponding statistics measured on the network.
}
\description{
A method for \code{\link[ergm]{summary_formula}} to calculate the
specified statistics for an observed \code{\link{networkDynamic}} at the
specified time point(s).  See \code{\link{ergm-terms}} for more information
on the statistics that may be specified.
}
\examples{

# create a toy dynamic network
my.nD <- network.initialize(100,directed=FALSE)
activate.vertices(my.nD, onset=0, terminus = 10)
add.edges.active(my.nD,tail=1:2,head=2:3,onset=5,terminus=8)

# use a summary formula to display number of isolates and edges
# at discrete time points
summary(my.nD~isolates+edges, at=1:10)
}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link{networkDynamic}}, \code{\link{ergm-terms}},
\link{summary.formula}
}
\keyword{models}
