% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{trim}
\alias{trim}
\title{Truncates small numbers to 0.}
\usage{
trim(X, epsilon = 10^-6)
}
\arguments{
\item{X}{An array, a matrix, or a vector.}

\item{epsilon}{A numeric.}
}
\description{
Given an array, matrix, or vector, \code{trim} will truncate all
elements smaller than \code{epsilon} (in absolute value) to zero.
}
\details{
All elements in \code{X} that are smaller than \code{epsilon} (in
absolute value) will be set to zero then returned.
}
\examples{
X <- c(0, 1, 10^-7, -1, -10^-7)
X
trim(X)
}
\author{
David Gerard.
}

