% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label2.R
\name{label2}
\alias{label2}
\title{Perform tensor clustering via TBM method}
\usage{
label2(x, k, r, l, lambda = 0, max.iter = 1000, threshold = 1e-10,
  sim.times = 1, trace = FALSE, Cs.init = NULL, Ds.init = NULL,
  Es.init = NULL, method = "L0")
}
\arguments{
\item{x}{a three-dimensional array}

\item{k}{\eqn{d_1}: the clusters number of mode 1}

\item{r}{\eqn{d_2}: the clusters number of mode 2}

\item{l}{\eqn{d_3}: the clusters number of mode 3}

\item{lambda}{a positive numeric value. The coefficient of the regularized term.}

\item{max.iter}{a positive integer. The Maximum times of iteration.}

\item{threshold}{a positive small numeric value which determines whether the algorithm converges or not.}

\item{sim.times}{the times of calling classify2() with different seeds.}

\item{trace}{logic value. If true, it would print the iteration situation.}

\item{Cs.init}{vector or NULL. Initial clsuter result of mode 1.}

\item{Ds.init}{vector or NULL. Initial clsuter result of mode 2.}

\item{Es.init}{vector or NULL. Initial clsuter result of mode 3.}

\item{method}{two options: "L0", "L1". Two methods use different penalties, where "L0" indicating L0 penalty and "L1" indicating Lasso penalty.}
}
\value{
a list   
\code{judgeX} estimated underlying mean signal.  

               \code{Cs} clustering result of mode 1.  
               
               \code{Ds} clustering result of mode 2.  
               
               \code{Es} clustering result of mode 3.  
               
               \code{mus} estimated underlying mean signal of each cluster.
}
\description{
Perform tensor clustering with TBM method in a more stable way. Repeat the classify2() many times and select the one with lowest MSE.
}
\examples{
x = get.data(20,20,20,2,2,2)$x
label2(x,2,2,2)
}
