% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitmodellist.R
\name{fitmodellist}
\alias{fitmodellist}
\title{Fit model list}
\usage{
fitmodellist(temp, rate, augment = F, return_fit = F,
  models = paste0("equ", 4:15))
}
\arguments{
\item{temp}{temperature (in Celsius)}

\item{rate}{rate measurement (for example growth rate, but could also be abundance)}

\item{augment}{logical wether the dataset with fits should be returned instead of the parameter values}

\item{return_fit}{logical should the model object be returned}

\item{models}{list of strings of equations to be fit such as paste0("equ",4:15)}
}
\value{
a data frame of, depending on augment argument, if FALSE, parameters, if TRUE, data with predicted values
}
\description{
Fits list of models (all models in package by default)
}
\examples{
output <- with(Emiliania_huxleyi, fitmodellist(temp=temp, rate=rate))
}
