% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_2.R
\name{vt2_rtree}
\alias{vt2_rtree}
\title{Estimate the CATE using a regression tree for Step 2}
\usage{
vt2_rtree(z, data, Trt, Y, theta)
}
\arguments{
\item{z}{a numeric vector of estimated CATEs from Step 1}

\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{theta}{tree complexity parameter (\code{cp})}
}
\value{
an object of class \code{rpart}. See
\code{\link[rpart]{rpart.object}}.
}
\description{
Estimate the CATE using a regression tree for Step 2
}
\seealso{
Other VT Step 2 functions: 
\code{\link{vt2_ctree}()},
\code{\link{vt2_lasso}()}
}
\concept{VT Step 2 functions}
