% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{watson_test}
\alias{watson_test}
\title{Watson's \eqn{U^2} Test of Circular Uniformity}
\usage{
watson_test(
  x,
  alpha = 0,
  dist = c("uniform", "vonmises"),
  axial = TRUE,
  mu = NULL
)
}
\arguments{
\item{x}{numeric vector. Values in degrees}

\item{alpha}{Significance level of the test. Valid levels are \code{0.01}, \code{0.05},
and \code{0.1}.
This argument may be omitted (\code{NULL}, the default), in which case, a range
for the p-value will be returned.}

\item{dist}{Distribution to test for. The default, \code{"uniform"}, is the
uniform distribution. \code{"vonmises"} tests the von Mises distribution.}

\item{axial}{logical. Whether the data are axial, i.e. \eqn{\pi}-periodical
(\code{TRUE}, the default) or circular, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{mu}{(optional) The specified mean direction (in degrees) in alternative
hypothesis}
}
\value{
list containing the test statistic \code{statistic} and the significance
level \code{p.value}.
}
\description{
Watson's test statistic is a rotation-invariant Cramer - von Mises test
}
\details{
If \code{statistic > p.value}, the null hypothesis is rejected.
If not, randomness (uniform distribution) cannot be excluded.
}
\examples{
# Example data from Mardia and Jupp (2001), pp. 93
pidgeon_homing <- c(55, 60, 65, 95, 100, 110, 260, 275, 285, 295)
watson_test(pidgeon_homing, alpha = .05)

# San Andreas Fault Data:
data(san_andreas)
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
watson_test(sa.por$azi.PoR, alpha = .05)
watson_test(sa.por$azi.PoR, alpha = .05, dist = "vonmises")
}
\references{
Mardia and Jupp (2000). Directional Statistics. John Wiley and
Sons.
}
