% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_binary_outcome.R
\name{tm_t_binary_outcome}
\alias{tm_t_binary_outcome}
\title{teal Module: Binary Outcome Table}
\usage{
tm_t_binary_outcome(
  label,
  dataname,
  parentname = ifelse(test = inherits(arm_var, "data_extract_spec"), yes =
    teal.transform::datanames_input(arm_var), no = "ADSL"),
  arm_var,
  arm_ref_comp = NULL,
  paramcd,
  strata_var,
  aval_var = teal.transform::choices_selected(choices =
    teal.transform::variable_choices(dataname, c("AVALC", "SEX")), selected = "AVALC",
    fixed = FALSE),
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  default_responses = c("CR", "PR", "Y", "Complete Response (CR)",
    "Partial Response (PR)", "M"),
  rsp_table = FALSE,
  control = list(global = list(method = ifelse(rsp_table, "clopper-pearson", "waldcc"),
    conf_level = 0.95), unstrat = list(method_ci = ifelse(rsp_table, "wald", "waldcc"),
    method_test = "schouten", odds = TRUE), strat = list(method_ci = "cmh", method_test =
    "cmh")),
  add_total = FALSE,
  total_label = default_total_label(),
  na_level = default_na_str(),
  pre_output = NULL,
  post_output = NULL,
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable(s) in the results table.
If there are two elements selected for \code{arm_var},
second variable will be nested under the first variable.}

\item{arm_ref_comp}{(\code{list}) optional,\cr if specified it must be a named list with each element corresponding to
an arm variable in \code{ADSL} and the element must be another list (possibly
with delayed \code{\link[teal.transform:variable_choices]{teal.transform::variable_choices()}} or delayed \code{\link[teal.transform:value_choices]{teal.transform::value_choices()}}
with the elements named \code{ref} and \code{comp} that the defined the default
reference and comparison arms when the arm variable is changed.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{strata_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr names of
the variables for stratified analysis.}

\item{aval_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the analysis variable.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{default_responses}{(\code{list} or \code{character})\cr defines
the default codes for the response variable in the module per value of \code{paramcd}.
A passed vector is transmitted for all \code{paramcd} values. A passed \code{list} must be named
and contain arrays, each name corresponding to a single value of \code{paramcd}. Each array
may contain default response values or named arrays \code{rsp} of default selected response
values and \code{levels} of default level choices.}

\item{rsp_table}{(\code{logical})\cr whether the initial set-up of the module should match \code{RSPT01}. Defaults to \code{FALSE}.}

\item{control}{(named \code{list})\cr named list containing 3 named lists as follows:
\itemize{
\item \code{global}: a list of settings for overall analysis with 2 named elements \code{method} and \code{conf_level}.
\item \code{unstrat}: a list of settings for unstratified analysis with 3 named elements \code{method_ci} and \code{method_test}, and
\code{odds}. See \code{\link[tern:prop_diff]{tern::estimate_proportion_diff()}}, \code{\link[tern:prop_diff_test]{tern::test_proportion_diff()}}, and
\code{\link[tern:odds_ratio]{tern::estimate_odds_ratio()}}, respectively, for options and details on how these settings are implemented in the
analysis.
\item \code{strat}: a list of settings for stratified analysis with elements \code{method_ci} and \code{method_test}. See
\code{\link[tern:prop_diff]{tern::estimate_proportion_diff()}} and \code{\link[tern:prop_diff_test]{tern::test_proportion_diff()}}, respectively, for options and details on
how these settings are implemented in the analysis.
}}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a binary outcome response summary table, with the option to match the template for
response table \code{RSPT01} available in the TLG Catalog \href{https://insightsengineering.github.io/tlg-catalog/stable/tables/efficacy/rspt01.html}{here}.
}
\details{
\itemize{
\item The display order of response categories inherits the factor level order of the source data. Use
\code{\link[base:factor]{base::factor()}} and its \code{levels} argument to manipulate the source data in order to include/exclude
or re-categorize response categories and arrange the display order. If response categories are \code{"Missing"},
\code{"Not Evaluable (NE)"}, or \code{"Missing or unevaluable"}, 95\% confidence interval will not be calculated.
\item Reference arms are automatically combined if multiple arms selected as reference group.
}
}
\examples{
library(dplyr)

ADSL <- tmc_ex_adsl
ADRS <- tmc_ex_adrs \%>\%
  mutate(
    AVALC = d_onco_rsp_label(AVALC) \%>\%
      with_label("Character Result/Finding")
  ) \%>\%
  filter(PARAMCD != "OVRINV" | AVISIT == "FOLLOW UP")

arm_ref_comp <- list(
  ARMCD = list(ref = "ARM B", comp = c("ARM A", "ARM C")),
  ARM = list(ref = "B: Placebo", comp = c("A: Drug X", "C: Combination"))
)
app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    ADRS = ADRS,
    code = "
      ADSL <- tmc_ex_adsl
      ADRS <- tmc_ex_adrs \%>\%
        mutate(
          AVALC = d_onco_rsp_label(AVALC) \%>\%
            with_label(\"Character Result/Finding\")
        ) \%>\%
        filter(PARAMCD != \"OVRINV\" | AVISIT == \"FOLLOW UP\")
    "
  ),
  modules = modules(
    tm_t_binary_outcome(
      label = "Responders",
      dataname = "ADRS",
      paramcd = choices_selected(
        choices = value_choices(ADRS, "PARAMCD", "PARAM"),
        selected = "BESRSPI"
      ),
      arm_var = choices_selected(
        choices = variable_choices(ADRS, c("ARM", "ARMCD", "ACTARMCD")),
        selected = "ARM"
      ),
      arm_ref_comp = arm_ref_comp,
      strata_var = choices_selected(
        choices = variable_choices(ADRS, c("SEX", "BMRKR2", "RACE")),
        selected = "RACE"
      ),
      default_responses = list(
        BESRSPI = list(
          rsp = c("Complete Response (CR)", "Partial Response (PR)"),
          levels = c(
            "Complete Response (CR)", "Partial Response (PR)",
            "Stable Disease (SD)", "Progressive Disease (PD)"
          )
        ),
        INVET = list(
          rsp = c("Stable Disease (SD)", "Not Evaluable (NE)"),
          levels = c(
            "Complete Response (CR)", "Not Evaluable (NE)", "Partial Response (PR)",
            "Progressive Disease (PD)", "Stable Disease (SD)"
          )
        ),
        OVRINV = list(
          rsp = c("Progressive Disease (PD)", "Stable Disease (SD)"),
          levels = c("Progressive Disease (PD)", "Stable Disease (SD)", "Not Evaluable (NE)")
        )
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
