% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_barchart_simple.R
\name{tm_g_barchart_simple}
\alias{tm_g_barchart_simple}
\title{teal Module: Simple Bar Chart and Table of Counts per Category}
\usage{
tm_g_barchart_simple(
  x = NULL,
  fill = NULL,
  x_facet = NULL,
  y_facet = NULL,
  label = "Count Barchart",
  plot_options = NULL,
  plot_height = c(600L, 200L, 2000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{x}{(\code{data_extract_spec})\cr variable on the x-axis.}

\item{fill}{(\code{data_extract_spec})\cr grouping variable to determine bar colors.}

\item{x_facet}{(\code{data_extract_spec})\cr row-wise faceting groups.}

\item{y_facet}{(\code{data_extract_spec})\cr column-wise faceting groups.}

\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{plot_options}{(\code{list})\cr list of plot options.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type bar chart and summary table of counts per category.
}
\details{
Categories can be defined up to four levels deep and are defined through the \code{x}, \code{fill},
\code{x_facet}, and \code{y_facet} parameters. Any parameters set to \code{NULL} (default) are ignored.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{plot} (\code{ggplot})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_barchart_simple(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...) # applied only to `plot` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
library(nestcolor)
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADSL <- tmc_ex_adsl \%>\%
    mutate(ITTFL = factor("Y") \%>\%
      with_label("Intent-To-Treat Population Flag"))
  ADAE <- tmc_ex_adae \%>\%
    filter(!((AETOXGR == 1) & (AESEV == "MILD") & (ARM == "A: Drug X")))
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADAE <- data[["ADAE"]]

app <- init(
  data = data,
  modules = modules(
    tm_g_barchart_simple(
      label = "ADAE Analysis",
      x = data_extract_spec(
        dataname = "ADSL",
        select = select_spec(
          choices = variable_choices(
            ADSL,
            c(
              "ARM", "ACTARM", "SEX",
              "RACE", "ITTFL", "SAFFL", "STRATA2"
            )
          ),
          selected = "ACTARM",
          multiple = FALSE
        )
      ),
      fill = list(
        data_extract_spec(
          dataname = "ADSL",
          select = select_spec(
            choices = variable_choices(
              ADSL,
              c(
                "ARM", "ACTARM", "SEX",
                "RACE", "ITTFL", "SAFFL", "STRATA2"
              )
            ),
            selected = "SEX",
            multiple = FALSE
          )
        ),
        data_extract_spec(
          dataname = "ADAE",
          select = select_spec(
            choices = variable_choices(ADAE, c("AETOXGR", "AESEV", "AESER")),
            selected = NULL,
            multiple = FALSE
          )
        )
      ),
      x_facet = list(
        data_extract_spec(
          dataname = "ADAE",
          select = select_spec(
            choices = variable_choices(ADAE, c("AETOXGR", "AESEV", "AESER")),
            selected = "AETOXGR",
            multiple = FALSE
          )
        ),
        data_extract_spec(
          dataname = "ADSL",
          select = select_spec(
            choices = variable_choices(
              ADSL,
              c(
                "ARM", "ACTARM", "SEX",
                "RACE", "ITTFL", "SAFFL", "STRATA2"
              )
            ),
            selected = NULL,
            multiple = FALSE
          )
        )
      ),
      y_facet = list(
        data_extract_spec(
          dataname = "ADAE",
          select = select_spec(
            choices = variable_choices(ADAE, c("AETOXGR", "AESEV", "AESER")),
            selected = "AESEV",
            multiple = FALSE
          )
        ),
        data_extract_spec(
          dataname = "ADSL",
          select = select_spec(
            choices = variable_choices(
              ADSL,
              c(
                "ARM", "ACTARM", "SEX",
                "RACE", "ITTFL", "SAFFL", "STRATA2"
              )
            ),
            selected = NULL,
            multiple = FALSE
          )
        )
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACIAygAyyTqkMARpcAAeaVD8otQ6AKQAfBP1DTowgonk7ACStrYAYp0AvCZQ6gHsCmAAmic207MQ8-NFpWnUUPRw1MdgqypkBrZEP4xwBI6AAKRFQwgSlhumyeAHMLkEGi1Gk4uj0+oNhvFdFc5g1jLRqORGOwAITsdgo2wAeQAGgBxLA6HZ7ACMNgAZDpKU5Wk4AGrMvYnACyq3azQuOi5lKwIqFOhOjUQOmajEEsJ0tIRQQAvkEAFZEcppADWcFYokqiRs+X4cGMUGEpDSBH4tFEfSNJvNluA0HgVtycgAurEWh0urlgMAlW12icQ2GIMjUXaqjG4yjE8mlGhUF1ysVjjcdLlmWWqrg5nwhCJRBXa8IxCXbj00rC0vQWAQSiwXaJaDBInBW7cdE8XuNhWBU01oFFB6ITtXS7cBhXcv0BqQ1APUHACGPx5XEgHdDOIwm8Hjx6JXofSBX7yJ1GlRAej7eT73jQQxBWmgsLQzwiK6JR-i234nk08arjB45fmuCHzEqcoroqs4AMK2I06F4JhfLajeyEoZhWCNFhLgESc6xbNeNQnK0jSbNsGFMfYjS4QATCc0EnoiKFyPBKEvo+cD8BWSo4XhIorvx8yLEStAjhWmyNO0fIKYJtzCdBBLUNOE4eqQx7jlugy7gc+6HmZJ65OeUmzvG8mkXeD7qM+Hk2UhZENL+MgAXsQGMCB9BgQF-5WgpJ5XiJfk6L5CWobO+GMdhuFpYRTjEfFyUnBRVHsR8GxsTRYDMaxDGEZxPF8W5CE6UJeUIWJ6gSU5RGuQlSkaKpezqZpLgNfMTW6S18wWTue7vp+dnmVUjmXs02YkWRbVPnsG2zbZMXzJFQU6CFYURRBgVWqmNRfrOTg0gyWDFSifL8o9vJOA9YByHpI23BtHV7AAcg47TtBNJ69SpIhqRpWk-ToY2jdB30nkMjr-ptxmiKZClTVZb4frtcMObAF6Yam3Wid5Xmvj580-mdUWAcBoFwOBkEXStThXe8VJ0oyr3PQL70ImD7k0-9ZO3XzH2i7cEP9Tog2w2RCMNMjMG4zNBNJQhxPwE5V4U61VNbd5O06yhB0NsFzPhazVt0zBcV7bcFsJWhcnlZRmWe+lXVrclDQFZR1HpXRZV+yxEc1RRdVgC7iNw2rsvzH9kmA8DoMJ-LUMDTDw0q9pSMTawaRo3AGN0Fjjua9Z5uOw0euk1mod7Rt1OPvXCdW0zoUs2z52Upz3NKlL91Cy9XtvR9X0pw0acG29k9zwszqQ6TSsF0J2mi7X+NzXtTcGy5AfGzTHf74TCU9zbfd2wPUUN+OztJ-tT8nh7j0yVlTE5Ub+VgEKqHTC4dqpMSjmAiqtVGi8Xjq-NWCd1brW8hLIGIMV45w3vnPaqt4ZI1vIJIIQRaDGG5OUYk1ktCji+rUOYogygQFYI0dA7B8wABJBC0BqOw+8jBtAxAgLqJQYBdQhiAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACIAygAyyTqkMARpcAAeaVD8otQ6AKQAfBP1DTowgonk7ACStrYAYp0AvCZQ6gHsCmAAmic207MQ8-NFpWnUUPRw1MdgqypkBrZEP4xwBI6AAKRFQwgSlhumyeAHMLkEGi1Gk4uj0+oNhvFdFc5g1jLRqORGOwAITsdgo2wAeQAGgBxLA6HZ7ACMNgAZDpKU5Wk4AGrMvYnACyq3azQuOi5lKwIqFOhOjUQOmajEEsJ0tIRQQAvkEAFZEcppADWcFYokqiRs+X4cGMUGEpDSBH4tFEfSNJvNluA0HgVtycgAurEWh0urlgMAlW12icQ2GIMjUXaqjG4yjE8mlGhUF1ysVjjcdLlmWWqrg5nwhCJRBXa8IxCXbj00rC0vQWAQSiwXaJaDBInBW7cdE8XuNhWBU01oFFB6ITtXS7cBhXcv0BqQ1APUHACGPx5XEgHdDOIwm8Hjx6JXofSBX7yJ1GlRAej7eT73jQQxBWmgsLQzwiK6JR-i234nk08arjB45fmuCHzEqcoroqs4AMK2I06F4JhfLajeyEoZhWCNFhLgESc6xbNeNQnK0jSbNsGFMfYjS4QATCc0EnoiKFyPBKEvo+cD8BWSo4XhIorvx8yLEStAjhWmyNO0fIKYJtzCdBBLUNOE4eqQx7jlugy7gc+6HmZJ65OeUmzvG8mkXeD7qM+Hk2UhZENL+MgAXsQGMCB9BgQF-5WgpJ5XiJfk6L5CWobO+GMdhuFpYRTjEfFyUnBRVHsR8GxsTRYDMaxDGEZxPF8W5CE6UJeUIWJ6gSU5RGuQlSkaKpezqZpLgNfMTW6S18wWTue7vp+dnmVUjmXs02YkWRbVPnsG2zbZMXzJFQU6CFYURRBgVWqmNRfrOTg0gyWDFSifL8o9vJOA9YByHpI23BtHV7AAcg47TtBNJ69SpIhqRpWk-ToY2jdB30nkMjr-ptxmiKZClTVZb4frtcMObAF6Yam3Wid5Xmvj580-mdUWAcBoFwOBkEXStThXe8VJ0oyr3PQL70ImD7k0-9ZO3XzH2i7cEP9Tog2w2RCMNMjMG4zNBNJQhxPwE5V4U61VNbd5O06yhB0NsFzPhazVt0zBcV7bcFsJWhcnlZRmWe+lXVrclDQFZR1HpXRZV+yxEc1RRdVgC7iNw2rsvzH9kmA8DoMJ-LUMDTDw0q9pSMTawaRo3AGN0Fjjua9Z5uOw0euk1mod7Rt1OPvXCdW0zoUs2z52Upz3NKlL91Cy9XtvR9X0pw0acG29k9zwszqQ6TSsF0J2mi7X+NzXtTcGy5AfGzTHf74TCU9zbfd2wPUUN+OztJ-tT8nh7j0yVlTE5Ub+VgEKqHTC4dqpMSjmAiqtVGi8Xjq-NWCd1brW8hLIGIMV45w3vnPaqt4ZI1vIJIIQRaDGG5OUYk1ktCji+rUOYogygQFYI0dA7B8wABJBC0BqOw+8jBtAxAgLqJQYBdQhiAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

