% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_key.R
\name{join_key}
\alias{join_key}
\title{Create a relationship between a pair of datasets}
\usage{
join_key(dataset_1, dataset_2 = dataset_1, keys, directed = TRUE)
}
\arguments{
\item{dataset_1, dataset_2}{(\code{character(1)}) Dataset names. When \code{dataset_2} is omitted,
a primary key for \code{dataset_1} is created.}

\item{keys}{(optionally named \code{character}) Column mapping between the datasets,
where \code{names(keys)} maps columns in \code{dataset_1} corresponding to columns of
\code{dataset_2} given by the elements of \code{keys}.
\itemize{
\item If unnamed, the same column names are used for both datasets.
\item If any element of the \code{keys} vector is empty with a non-empty name, then the name is
used for both datasets.
}}

\item{directed}{(\code{logical(1)}) Flag that indicates whether it should create
a parent-child relationship between the datasets.
\itemize{
\item \code{TRUE} (default) \code{dataset_1} is the parent of \code{dataset_2};
\item \code{FALSE} when the relationship is undirected.
}}
}
\value{
object of class \code{join_key_set} to be passed into \code{join_keys} function.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Create a relationship between two datasets, \code{dataset_1} and \code{dataset_2}.
By default, this function establishes a directed relationship with \code{dataset_1} as the parent.
If \code{dataset_2} is not specified, the function creates a primary key for \code{dataset_1}.
}
\examples{
join_key("d1", "d2", c("A"))
join_key("d1", "d2", c("A" = "B"))
join_key("d1", "d2", c("A" = "B", "C"))

}
\seealso{
\code{\link[=join_keys]{join_keys()}}, \code{\link[=parents]{parents()}}
}
