\name{GH}
\alias{GH}
\title{
A Bias-based procedure for Choosing the Optimal Threshold
}
\description{
An Implementation of the procedure proposed in Guillou & Hall(2001) for selecting the optimal threshold in extreme value analysis.
}
\usage{
GH(data)
}
\arguments{
  \item{data}{vector of sample data}
}
\details{
The procedure proposed in Guillou & Hall (2001) is based on bias reduction. Due to the fact that the log-spacings of the order statistics are approximately exponentially distributed if the tail of the underlying distribution follows a Pareto distribution, an auxilliary statistic with respect to \code{k} is implemented with the same properties. The method then behaves like an asymptotic test for mean \code{0}. If some critical value \code{crit} is exceeded the hypothesis of zero mean is rejected. Thus the bias has become too large and the assumed exponentiality and therefore the assumed Pareto tail can not be hold.  From this an optimal number of \code{k} can be found such that the critical value is not exceeded. This optimal number, denoted \code{k0} here, is equivalent to the number of extreme values or, if you wish, the number of exceedances in the context of a POT-model like the generalized Pareto distribution. \code{k0} can then be associated with the unknown threshold \code{u} of the GPD by choosing \code{u} as the \code{n-k0}th upper order statistic. For more information see references.
}
\value{
  \item{k0}{optimal number of upper order statistics, i.e. number of exceedances or data in the tail}
  \item{threshold}{the corresponding threshold}
  \item{tail.index}{the corresponding tail index}
}
\references{
Guillou, A. and Hall, P. (2001)
A Diagnostic for Selecting the Threshold in Extreme Value Analysis
\emph{Journal of the Royal Statistical Society}, \bold{63(2)}, 293--305
}
\examples{
data(danish)
GH(danish)
}
