% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert.to.daily}
\alias{convert.to.daily}
\title{Convert Data to Daily Frequency}
\usage{
convert.to.daily(variable, aggregateFun = NULL)
}
\arguments{
\item{variable}{A variable.}

\item{aggregateFun}{Function to aggregate data within each interval (see details).}
}
\value{
A variable with daily frequency, with data sorted from the original variable and missing dates filled with \code{NA}.
}
\description{
Use this function to convert a time-series data (currently implemented: \code{Date-List}, \code{Daily-In-Week}) to a time-series data with daily frequency.
}
\details{
In some cases, conversion sorts the dates and fills any gaps between them with \code{NA}.
However, in other cases, conversion requires aggregation. For example,
when aggregating hourly data over a period of \code{k} hours to generate daily data,
we expect \code{k} numbers in each interval.
The aggregate function can be set to calculate the mean,
variance, median, etc., or any function that takes
the vector of \code{k} values and returns a number.
}
\examples{
startFreq <- f.list.date(c("20220904","20220901"), "20220901")
v <- variable(c(4,1), startFreq)
w <- convert.to.daily(v)
}
