% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R, R/tcplObjCnst.R, R/tcplObjGnls.R,
%   R/tcplObjHill.R
\name{Models}
\alias{Models}
\alias{tcplObjCnst}
\alias{tcplObjGnls}
\alias{tcplObjHill}
\title{Model objective functions}
\usage{
tcplObjCnst(p, resp)

tcplObjGnls(p, lconc, resp)

tcplObjHill(p, lconc, resp)
}
\arguments{
\item{p}{Numeric, the parameter values. See details for more information.}

\item{resp}{Numeric, the response values}

\item{lconc}{Numeric, the log10 concentration values}
}
\value{
The log-likelyhood.
}
\description{
These functions take in the dose-response data and the model parameters, and
return a likelyhood value. They are intended to be optimized using 
\code{\link{constrOptim}} in the \code{\link{tcplFit}} function.
}
\details{
These functions produce an estimated value based on the model and given 
parameters for each observation. Those estimated values are then used with 
the observed values and a scale term to calculate the log-likelyhood.

Let \eqn{t(z,\nu)} be the Student's t-ditribution with \eqn{\nu} degrees of
freedom, \eqn{y_{i}}{y[i]} be the observed response at the \eqn{i^{th}}{ith} 
observation, and \eqn{\mu_{i}}{\mu[i]} be the estimated response at the \eqn{i^{th}}{ith} 
observation. We calculate \eqn{z_{i}}{z[i]} as:
\deqn{
z_{i} = \frac{y_{i} - \mu_{i}}{e^\sigma}
}{
z[i] = (y[i] - \mu[i])/e^\sigma
}
where \eqn{\sigma} is the scale term. Then the log-likelyhood is:
\deqn{
\sum_{i=1}^{n} [ln(t(z_{i}, 4)) - \sigma]
}{
sum_{i=1}^{n} [ln(t(z[i], 4)) - \sigma]}
Where \eqn{n} is the number of observations.
}
\section{Constant Model (cnst)}{
 
\code{tcplObjCnst} calculates the likelyhood for a constant model at 0. The 
only parameter passed to \code{tcplObjCnst} by \code{p} is the scale term 
\eqn{\sigma}. The constant model value \eqn{\mu_{i}}{\mu[i]} for the  
\eqn{i^{th}}{ith} observation is given by:
\deqn{\mu_{i} = 0}{\mu[i] = 0}
}

\section{Gain-Loss Model (gnls)}{
 
\code{tcplObjGnls} calculates the likelyhood for a 5 parameter model as the 
product of two Hill models with the same top and both bottoms equal to 0. 
The parameters passed to \code{tcplObjGnls} by \code{p} are (in order) top 
(\eqn{\mathit{tp}}), gain log AC50 (\eqn{\mathit{ga}}), gain hill coefficient (\eqn{gw}), 
loss log AC50 \eqn{\mathit{la}}, loss hill coefficient \eqn{\mathit{lw}}, and the scale 
term (\eqn{\sigma}). The gain-loss model value \eqn{\mu_{i}}{\mu[i]} for the 
\eqn{i^{th}}{ith} observation is given by:
\deqn{
g_{i} = \frac{1}{1 + 10^{(\mathit{ga} - x_{i})\mathit{gw}}}
}{
g[i] = 1/(1 + 10^(ga - x[i])*gw)}
\deqn{
l_{i} = \frac{1}{1 + 10^{(x_{i} - \mathit{la})\mathit{lw}}}
}{
l[i] = 1/(1 + 10^(x[i] - la)*lw)}
\deqn{\mu_{i} = \mathit{tp}(g_{i})(l_{i})}{\mu[i] = tp*g[i]*l[i]}
where \eqn{x_{i}}{x[i]} is the log concentration for the \eqn{i^{th}}{ith} 
observation.
}

\section{Hill Model (hill)}{
 
\code{tcplObjHill} calculates the likelyhood for a 3 parameter Hill model
with the bottom equal to 0. The parameters passed to \code{tcplObjHill} by 
\code{p} are (in order) top (\eqn{\mathit{tp}}), log AC50 (\eqn{\mathit{ga}}), hill 
coefficient (\eqn{\mathit{gw}}), and the scale term (\eqn{\sigma}). The hill model 
value \eqn{\mu_{i}}{\mu[i]} for the \eqn{i^{th}}{ith} observation is given 
by:
\deqn{
\mu_{i} = \frac{tp}{1 + 10^{(\mathit{ga} - x_{i})\mathit{gw}}}
}{
\mu[i] = tp/(1 + 10^(ga - x[i])*gw)}
where \eqn{x_{i}}{x[i]} is the log concentration for the \eqn{i^{th}}{ith} 
observation.
}

