[manpage_begin Diagrams n 0.2]
[moddesc {Tk Diagrams}]
[titledesc {User documentation of the Diagrams package}]
[require Tcl 8.4]
[require Tk 8.4]
[require Diagrams 0.2]
[description]
[para]
The [package Diagrams] package is meant to help drawing diagrams, like
flowcharts. The philosophy is that you should be concentrating on the
contents of the diagram, rather than the exact positioning and sizing
of all items within it. The Diagrams package uses a few simple rules
to layout the items:

[list_begin bullet]
[bullet]
Each item (or object) in the diagram has a number of "anchors" - places
where arrows and lines can be connected to.

[bullet]
You can draw an arrow or a line from an object in a preset direction

[bullet]
Sizing and positioning should be done as automatic as possible: this is
achieved for instance by drawing boxes and circles with text, rather
than first drawing a rectangle and then drawing the text inside it or
vice versa.

[list_end]

The commands within this package can be split up in several
categories. Each category is described in a separate section.

[section "GENERAL COMMANDS FOR POSITIONING AND SETUP"]

[list_begin definitions]

[call [cmd ::Diagrams::drawin] [arg canvas]]
Set the canvas widget in which to draw
[list_begin arg]
[arg_def widget canvas] Widget to draw in
[list_end]
[nl]

[call [cmd ::Diagrams::saveps] [arg filename]]
Save the drawing in a PostScript file
[list_begin arg]
[arg_def filename string] Name of the file to save the drawing in
[list_end]
[nl]

[call [cmd ::Diagrams::direction] [arg newdir]]
Set the direction for moving the current position.
The direction is one of:
north  northeast  east southeast  south
southwest west northwest
N      NE         E    SE         S     SW        W    NW
up     up-right   left down-right down  down-left left up-left
centre center     C
[list_begin arg]
[arg_def newdir string] New direction
[list_end]
[nl]

[call [cmd ::Diagrams::currentpos] [arg pos]]
Set the current position explicitly (argument must be
a position "object")
[list_begin arg]
[arg_def pos list] New position (retrieve via [emph getpos] for instance)
[list_end]
[nl]

[call [cmd ::Diagrams::getpos] [arg anchor] [arg obj]]
Get the position of a particular "anchor" point of an object
anchor should be one of the direction strings
[list_begin arg]
[arg_def anchor string] Name of the anchor (one of the directions - see
the [emph direction] command
[arg_def obj list] The object in question
[list_end]
[nl]

[call [cmd ::Diagrams::position] [arg xcoord] [arg ycoord]]
Create a position "object"
[list_begin arg]
[arg_def xcoord float] X-coordinate of the position
[arg_def ycoord float] Y-coordinate of the position
[list_end]

[list_end]

[section "DRAWING OBJECTS"]

[list_begin definitions]

[call [cmd ::Diagrams::box] [arg text] [arg width] [arg height]]
Draw a box from the current position
(width and height are both optional; if not given, the text
determines the width and height)
[list_begin arg]
[arg_def string text] Text to be shown inside the box
[arg_def float width] Width (if any) of the box in pixels
[arg_def float height] Height (if any) of the box in pixels
[list_end]
[nl]

[call [cmd ::Diagrams::plaintext] [arg text] [arg width] [arg height]]
Draw plain text from the current position
(width and height are both optional; if not given, the text
determines the width and height)
[list_begin arg]
[arg_def string text] Text to be shown
[arg_def float width] Width (if any) of the (invisible) box in which to
position the text
[arg_def float height] Height (if any) of the box
[list_end]
[nl]

[call [cmd ::Diagrams::circle] [arg text] [arg radius]]
Draw a circle from the current position
(the radius is optional)
[list_begin arg]
[arg_def string text] Text to be shown inside the circle
[arg_def float radius] Radius (if any) of the circle in pixels
[list_end]
[nl]

[call [cmd ::Diagrams::slanted] [arg text] [arg width] [arg height] [arg angle]]
Draw a slanted box from the current position
(width, height and angle are optional)
[list_begin arg]
[arg_def string text] Text to be shown inside the box
[arg_def float width] Width (if any) of the box in pixels
[arg_def float height] Height (if any) of the box in pixels
[arg_def float angle] Angle of the slanted box
[list_end]
[nl]

[call [cmd ::Diagrams::diamond] [arg text] [arg width] [arg height]]
Draw a diamond-shaped box from the current position
(width and height are both optional; if not given, the text
determines the width and height)
[list_begin arg]
[arg_def string text] Text to be shown inside the diamond
[arg_def float width] Width (if any) of the diamond in pixels
[arg_def float height] Height (if any) of the diamond in pixels
[list_end]
[nl]

[call [cmd ::Diagrams::drum] [arg text] [arg width] [arg height]]
Draw a drumshaped item from th ecurrent position
(width and height are both optional; if not given, the text
determines the width and height)
[list_begin arg]
[arg_def string text] Text to be shown inside the drum
[arg_def float width] Width (if any) of the drum in pixels
[arg_def float height] Height (if any) of the drum in pixels
[list_end]
[nl]

[call [cmd ::Diagrams::arrow] [arg text] [arg length] [arg heads]]
Draw an arrow from the current position to the next.
The text is drawn next to the arrow, the length (in pixels) is
optional. If not given the gap parameters are used.
[list_begin arg]
[arg_def string text] Text to be shown along the arrow
[arg_def float length] Length of the arrow in pixels
[arg_def float heads] Which arrow heads to draw (first, last
or both - defaults to last)
[list_end]
[nl]

[call [cmd ::Diagrams::line] [arg args]]
Draw a line specified via positions or via line segments
The arguments are either position or length-angle pairs
[list_begin arg]
[arg_def list args] List of positions or of length-angle pairs
[list_end]
[nl]

[list_end]

[section "ATTRIBUTES"]

(Note: attributes are persistent)

[list_begin definitions]
[call [cmd ::Diagrams::attach] [arg anchor]]
Set the anchor point for attaching arrows to
[list_begin arg]
[arg_def string anchor] Any one of the valid anchor (e.g. N or North)
[list_end]
[nl]

[call [cmd ::Diagrams::color] [arg name]]
Set the color for the outline of a box etc.
[list_begin arg]
[arg_def color name] Name of the colour to be used
[list_end]
[nl]

[call [cmd ::Diagrams::fillcolor] [arg name]]
Set the color to fill the objects
[list_begin arg]
[arg_def color name] Name of the colour to be used
[list_end]
[nl]

[call [cmd ::Diagrams::textcolor] [arg name]]
Set the color to draw the text in
[list_begin arg]
[arg_def color name] Name of the colour to be used
[list_end]
[nl]

[call [cmd ::Diagrams::usegap] [arg use]]
Turn the gap on (1) or off (0). Note: usually a small gap is used
when positioning objects.
[list_begin arg]
[arg_def boolean use] Use the gap to compute the position of the next object or not
[list_end]
[nl]

[call [cmd ::Diagrams::xgap] [arg value]]
Size of the gap in horizontal direction (in pixels)
[list_begin arg]
[arg_def integer value] Gap width in pixels
[list_end]
[nl]

[call [cmd ::Diagrams::ygap] [arg value]]
Size of the gap in vertical direction (in pixels)
[list_begin arg]
[arg_def integer value] Gap height in pixels
[list_end]
[nl]

[call [cmd ::Diagrams::textfont] [arg name]]
Set the name of the font to use
[list_begin arg]
[arg_def string name] Name of a text font
[list_end]
[nl]

[call [cmd ::Diagrams::linewidth] [arg pixels]]
Set the width of the lines (in line objects and arrows and the outline
of boxes and other objects)
[list_begin arg]
[arg_def integer pixels] Number of pixels the lines are wide
[list_end]
[nl]

[call [cmd ::Diagrams::linestyle] [arg style]]
Set the style of the lines and arrows and of the outline of boxes and
other objects. The predefined line styles are: solid, dot, dash,
dash-dot, dash-dot-dot (these are the distinguishable line styles on
Windows). You can also use the style patterns from the canvas directly.
[list_begin arg]
[arg_def string style] Name of a valid line style
[list_end]
[nl]

[list_end]

[section "COMMANDS FOR IMPLEMENTING NEW OBJECTS"]

Note: it is best to study how for instance box objects are implemented
first.

[list_begin definitions]
[call [cmd ::Diagrams::pushstate]]
Save the current global settings
Used when defining an object that is composed of other objects

[call [cmd ::Diagrams::popstate]]
Restore the previously saved global settings

[call [cmd ::Diagrams::computepos]]
Compute the current position

[call [cmd ::Diagrams::boxcoords] [arg x1] [arg y1] [arg x2] [arg y2]]
Compute the anchor coordinates for a box-like object
(this is merely a convenience routine. In general, you will
have to compute the list of coordinates yourself - see
for instance the diamond object)
[list_begin arg]
[arg_def float x1] X coordinate of upper-left corner
[arg_def float y1] Y coordinate of upper-left corner
[arg_def float x2] X coordinate of lower-right corner
[arg_def float y2] Y coordinate of lower-right corner
[list_end]
[nl]

[call [cmd ::Diagrams::moveobject] [arg obj]]
Move the object to the right position and return the new
information
[list_begin arg]
[arg_def list obj] List of data representing the object
[list_end]
[nl]

[list_end]


[keywords diagrams drawing]

[manpage_end]
