% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Clipping}
\alias{Clipping}
\title{Builds and plots the mesh representing the desired isosurface of an specific region of the dataset}
\usage{
Clipping(file_path, isovalue, verification, color_mesh, opacity,
  new_window, range_x, range_y, range_z)
}
\arguments{
\item{file_path}{A string: the path to the nhdr file}

\item{isovalue}{A number: the value corresponding to the desired isosurface}

\item{verification}{A boolean: determines whether the grid verification will be performed}

\item{color_mesh}{A string: the color to rendirind the resulting mesh}

\item{opacity}{A number: the opacity-level}

\item{new_window}{A boolean: determines whether a new view window will open}

\item{range_x}{A vector contaning the clipping limits of the dataset in the x axis.}

\item{range_y}{A vector contaning the clipping limits of the dataset in the y axis.}

\item{range_z}{A vector contaning the clipping limits of the dataset in the z axis.}
}
\value{
The visualization of the generated mesh.
}
\description{
This function returns the visualization of an specific region of the dataset.
}
\examples{
Clipping(system.file("extdata","f3.nhdr",package ="tcie"),0,FALSE,"red",1,TRUE,c(2,3),c(2,4),c(2,4))
Clipping(system.file("extdata","f3.nhdr",package ="tcie"),0,TRUE,"red",1,TRUE,c(2,3),c(2,4),c(2,4))
Clipping(system.file("extdata","f9.nhdr",package ="tcie"),0,TRUE,"blue",1,TRUE,c(1,5),c(2,4),c(3,5))
}
