% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datatools.R
\name{group.clonotypes}
\alias{group.clonotypes}
\title{Get all unique clonotypes.}
\usage{
group.clonotypes(.data, .gene.col = "V.segments", .count.col = "Read.count",
  .prop.col = "Read.proportion", .seq.col = "CDR3.amino.acid.sequence")
}
\arguments{
\item{.data}{Either tcR data frame or a list with data frames.}

\item{.gene.col}{Either name of the column with gene segments used to compare clonotypes
or NA if you don't need comparing using gene segments.}

\item{.count.col}{Name of the column with counts for each clonotype.}

\item{.prop.col}{Name of the column with proportions for each clonotype.}

\item{.seq.col}{Name of the column with clonotypes' CDR3 sequences.}
}
\value{
Data frame or a list with data frames with updated counts and proportion columns
and rows with unique clonotypes only.
}
\description{
Get all unique clonotypes with merged counts. Unique clonotypes are those with
either equal CDR3 sequence or with equal CDR3 sequence and equal gene segments.
Counts of equal clonotypes will be summed up.
}
\examples{
\dontrun{
tmp <- data.frame(A = c('a','a','b','c', 'a')
B = c('V1', 'V1','V1','V2', 'V3')
C = c(10,20,30,40,50), stringsAsFactors = F)
tmp
#   A  B  C
# 1 a V1 10
# 2 a V1 20
# 3 b V1 30
# 4 c V2 40
# 5 a V3 50
group.clonotypes(tmp, 'B', 'C', 'A')
#  A  B  C
#  1 a V1 30
#  3 b V1 50
#  4 c V2 30
#  5 a V3 40
group.clonotypes(tmp, NA, 'C', 'A')
#   A  B  C
# 1 a V1 80
# 3 b V1 30
# 4 c V2 40
# For tcR data frame:
data(twb)
twb1.gr <- group.clonotypes(twb[[1]])
twb.gr <- group.clonotypes(twb)
}
}

