% Generated by roxygen2 (4.0.2): do not edit by hand
\name{find.clonotypes}
\alias{find.clonotypes}
\title{Find target clonotypes and get columns' value corresponded to that clonotypes.}
\usage{
find.clonotypes(.data, .targets, .method = c("exact", "hamm", "lev"),
  .col.name = "Read.count", .target.col = "CDR3.amino.acid.sequence",
  .verbose = T)
}
\arguments{
\item{.data}{List with mitcr data.frames or a mitcr data.frame.}

\item{.targets}{Target sequences or elements to search. Either character vector or a matrix / data frame (not a data table!) with two columns: first for sequences, second for V-segments.}

\item{.method}{Method, which will be used to find clonotypes:

- "exact" performs exact matching of targets;

- "hamm" finds targets and close sequences using hamming distance <= 1;

- "lev" finds targets and close sequences using levenshtein distance <= 1.}

\item{.col.name}{Character vector with column names which values should be returned.}

\item{.target.col}{Character vector specifying name of columns in which function will search for a targets.
Only first column's name will be used for matching by different method, others will match exactly.
\code{.targets} should be a two-column character matrix or data frame with second column for V-segments.}

\item{.verbose}{If T than print messages about the search process.}
}
\value{
Data.frame.
}
\description{
Find the given target clonotypes in the given list of data.frames and get corresponding values of desired columns.
}
\examples{
\dontrun{
# Get ranks of all given sequences in a list of data frames.
immdata <- set.rank(immdata)
find.clonotypes(.data = immdata, .targets = head(immdata[[1]]$CDR3.amino.acid.sequence),
                .method = 'exact', .col.name = "Rank", .target.col = "CDR3.amino.acid.sequence")
# Find close by levenhstein distance clonotypes with similar V-segments and return
# their values in columns 'Read.count' and 'Total.insertions'.
find.clonotypes(.data = twb, .targets = twb[[1]][, c('CDR3.amino.acid.sequence', 'V.segments')],
                .col.name = c('Read.count', 'Total.insertions'), .method = 'lev',
                .target.col = c('CDR3.amino.acid.sequence', 'V.segments'))
}
}

