% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cosine.sharing}
\alias{cosine.sharing}
\alias{shared.clones.count}
\alias{shared.representation}
\alias{shared.summary}
\title{Shared repertoire analysis.}
\usage{
cosine.sharing(.shared.rep, .log = T)

shared.representation(.shared.rep)

shared.clones.count(.shared.rep)

shared.summary(.shared.rep, .min.ppl = min(.shared.rep$People),
               .max.ppl = max(.shared.rep$People))
}
\arguments{
\item{.shared.rep}{Shared repertoire, obtained from the function \code{shared.repertoire}.}

\item{.log}{If T than apply log to the after adding laplace correction equal to one.}

\item{...}{Parameters passed to the \code{prcomp} function.}

\item{.min.ppl}{Filter: get sequences with # people >= .min.ppl.}

\item{.max.ppl}{Filter: get sequences with # people <= .max.ppl.}
}
\value{
Plot or PCA resulr for the \code{shared.seq.pca} function or a matrix with cosine similarity values for the \code{cosine.sharing} function.
}
\description{
Functions for computing statistics and analysis of shared repertoire of sequences.

\code{cosine.sharing} - apply the cosine similarity measure to the vectors of sequences' counts or indices.

\code{shared.representation} - for every repertoire in the shared repetoire get a number of sequences in this repertoire which are in the other repertoires.
Row names of the input matrix is the number of people.

\code{shared.clones.count} - get the number of shared clones for every number of people.

\code{shared.summary} - get a matrix with counts of pairwise shared sequences (like a result from \code{cross} function, applied to a list of data frames).
}
\examples{
\dontrun{
# Load the twb data.
data(twb)
# Create shared repertoire on the twins data using CDR3 amino acid sequences with CDR1-2.
twb.shared <- shared.repertoire(twb, 'av', .verbose = T)
sh.repr <- shared.representation(twb.shared)
sh.repr
# Get proportion of represented shared sequences.
apply(sh.repr, 2, function (col) col / col[1])
}
}
\seealso{
\link{shared.repertoire}
}

